<?php include "db.php"; 

session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    echo "<script>alert('⚠️ Access denied! Admins only.'); window.location.href='dashboard.php';</script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Management</title>
<style>
body {
  font-family: "Poppins", sans-serif;
  background: #f5f7fa;
  margin: 0;
}
.container {
  display: flex;
  gap: 20px;
  padding: 20px;
  min-height: 100vh;
}
.left-panel, .right-panel {
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 3px 8px rgba(0,0,0,0.08);
  padding: 25px;
}
.left-panel {
  flex: 1;
  display: flex;
  flex-direction: column;
  gap: 12px;
}
.right-panel {
  flex: 2;
  overflow-y: auto;
}
h2 {
  color: #007bff;
  border-bottom: 2px solid #007bff;
  padding-bottom: 6px;
}
.form-group {
  display: flex;
  flex-direction: column;
  gap: 5px;
}
.form-group input, .form-group select {
  padding: 10px;
  border: 1px solid #ccc;
  border-radius: 6px;
}
button {
  padding: 10px;
  background: #007bff;
  color: white;
  border: none;
  border-radius: 6px;
  cursor: pointer;
  font-weight: 600;
}
button:hover { background: #0056b3; }

table {
  width: 100%;
  border-collapse: collapse;
  font-size: 14px;
}
th, td {
  border: 1px solid #eee;
  padding: 8px 10px;
  text-align: left;
}
th {
  background: #eef7ff;
  color: #007bff;
}
tr:nth-child(even) {
  background: #f9f9f9;
}
.action-btn {
  background: #28a745;
  border: none;
  color: white;
  padding: 5px 8px;
  border-radius: 5px;
  cursor: pointer;
  font-size: 12px;
}
.action-btn.delete {
  background: #dc3545;
}
</style>
</head>
<body>

<div class="container">
  <!-- ✅ Left: User Form -->
  <div class="left-panel">
    <h2>User Management</h2>
    <form id="userForm">
      <input type="hidden" name="id" id="user_id">
      <div class="form-group">
        <label>Username</label>
        <input type="text" name="username" id="username" required>
      </div>
      <div class="form-group">
        <label>Password</label>
        <input type="password" name="password" id="password" required>
      </div>
      <div class="form-group">
        <label>User Role</label>
        <select name="role" id="role" required>
          <option value="admin">Admin</option>
          <option value="manager">Manager</option>
          <option value="staff">Staff</option>
        </select>
      </div>
      <div class="form-group" style="display:flex; gap:10px;">
        <button type="submit" id="saveBtn">➕ Add</button>
        <button type="button" id="updateBtn" style="background:#ffc107; color:black;">✏️ Update</button>
        <button type="button" id="deleteBtn" style="background:#dc3545;">🗑️ Delete</button>
      </div>
    </form>
  </div>

  <!-- ✅ Right: User Table -->
  <div class="right-panel">
    <h2>User List</h2>
    <table id="userTable">
      <thead>
        <tr>
          <th>ID</th>
          <th>Username</th>
          <th>Role</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
// ✅ Load Users
function loadUsers() {
  fetch('user_action.php?action=fetch')
  .then(res => res.text())
  .then(html => document.querySelector('#userTable tbody').innerHTML = html);
}
loadUsers();

// ✅ Add User
document.getElementById('userForm').addEventListener('submit', e => {
  e.preventDefault();
  const formData = new FormData(e.target);
  formData.append('action', 'add');
  fetch('user_action.php', { method: 'POST', body: formData })
  .then(res => res.text())
  .then(data => {
    alert(data);
    e.target.reset();
    loadUsers();
  });
});

// ✅ Update User
document.getElementById('updateBtn').addEventListener('click', () => {
  const id = document.getElementById('user_id').value;
  if (!id) return alert('Select a user first!');
  const formData = new FormData(document.getElementById('userForm'));
  formData.append('action', 'update');
  fetch('user_action.php', { method: 'POST', body: formData })
  .then(res => res.text())
  .then(data => {
    alert(data);
    document.getElementById('userForm').reset();
    loadUsers();
  });
});

// ✅ Delete User
document.getElementById('deleteBtn').addEventListener('click', () => {
  const id = document.getElementById('user_id').value;
  if (!id) return alert('Select a user first!');
  if (!confirm('Are you sure to delete this user?')) return;
  fetch('user_action.php?action=delete&id=' + id)
  .then(res => res.text())
  .then(data => {
    alert(data);
    document.getElementById('userForm').reset();
    loadUsers();
  });
});

// ✅ Select Row (for edit)
document.addEventListener('click', e => {
  if (e.target.closest('#userTable tbody tr')) {
    const row = e.target.closest('tr').children;
    document.getElementById('user_id').value = row[0].innerText;
    document.getElementById('username').value = row[1].innerText;
    document.getElementById('role').value = row[2].innerText;
    document.getElementById('password').value = '';
  }
});
</script>

</body>
</html>
