<?php
include "db.php";

$action = $_REQUEST['action'] ?? '';

if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// ✅ ADD USER
if ($action == 'add') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? '';

    if (empty($username) || empty($password) || empty($role)) {
        echo "❌ Please fill all fields!";
        exit;
    }

    // Hash password for security
    $hashed = password_hash($password, PASSWORD_DEFAULT);

    $stmt = $conn->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
    if (!$stmt) {
        echo "❌ Prepare failed: " . $conn->error;
        exit;
    }

    $stmt->bind_param("sss", $username, $hashed, $role);
    if ($stmt->execute()) {
        echo "✅ User added successfully!";
    } else {
        echo "❌ Error adding user: " . $stmt->error;
    }
    $stmt->close();
    exit;
}

// ✅ UPDATE USER
if ($action == 'update') {
    $id = intval($_POST['id'] ?? 0);
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? '';

    if ($id <= 0 || empty($username) || empty($role)) {
        echo "❌ Invalid data!";
        exit;
    }

    if (!empty($password)) {
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET username=?, password=?, role=? WHERE id=?");
        $stmt->bind_param("sssi", $username, $hashed, $role, $id);
    } else {
        $stmt = $conn->prepare("UPDATE users SET username=?, role=? WHERE id=?");
        $stmt->bind_param("ssi", $username, $role, $id);
    }

    if ($stmt->execute()) {
        echo "✅ User updated successfully!";
    } else {
        echo "❌ Error updating user: " . $stmt->error;
    }
    $stmt->close();
    exit;
}

// ✅ DELETE USER
if ($action == 'delete') {
    // Accept ID from POST or GET
    $id = isset($_POST['id']) ? intval($_POST['id']) : intval($_GET['id'] ?? 0);

    if ($id <= 0) {
        echo "❌ Invalid user ID!";
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    if (!$stmt) {
        echo "❌ Prepare failed: " . $conn->error;
        exit;
    }

    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        echo "✅ User deleted successfully!";
    } else {
        echo "❌ Error deleting user: " . $stmt->error;
    }
    $stmt->close();
    exit;
}


// ✅ FETCH USERS
if ($action == 'fetch') {
    $res = $conn->query("SELECT id, username, role FROM users ORDER BY id DESC");
    if (!$res) {
        echo "❌ Query failed: " . $conn->error;
        exit;
    }

    // echo "<table border='1' width='100%' cellspacing='0' cellpadding='5'>
    //         <tr>
    //             <th>ID</th>
    //             <th>Username</th>
    //             <th>Role</th>
                
    //         </tr>";

    if ($res->num_rows > 0) {
        while ($row = $res->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['id']}</td>
                    <td>{$row['username']}</td>
                    <td>{$row['role']}</td>
                
                  </tr>";
        }
    } else {
        echo "<tr><td colspan='4' style='text-align:center;'>No users found</td></tr>";
    }

    echo "</table>";
    exit;
}

$conn->close();
?>
