<?php
include "db.php";
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$action = $_GET['action'] ?? '';

/* =======================================================
   ✅ 1. FETCH TRANSACTIONS (same as before)
   ======================================================= */
if ($action == 'fetch') {
  $from = $_GET['from'] ?? '';
  $to   = $_GET['to'] ?? '';
  $type = $_GET['type'] ?? '';
  $dir  = $_GET['dir'] ?? '';
  $page = intval($_GET['page'] ?? 1);
  $limit = 10;
  $offset = ($page - 1) * $limit;

  $where = "WHERE DATE(created_at) BETWEEN ? AND ?";
  $params = [$from, $to];
  $types = "ss";

  if (!empty($type)) {
    $where .= " AND type=?";
    $params[] = $type;
    $types .= "s";
  }
  if (!empty($dir)) {
    $where .= " AND direction=?";
    $params[] = $dir;
    $types .= "s";
  }

  $countQuery = "SELECT COUNT(*) as total FROM transactions $where";
  $stmt = $conn->prepare($countQuery);
  $stmt->bind_param($types, ...$params);
  $stmt->execute();
  $total = $stmt->get_result()->fetch_assoc()['total'];
  $stmt->close();

  $query = "SELECT * FROM transactions $where ORDER BY id DESC LIMIT $limit OFFSET $offset";
  $stmt = $conn->prepare($query);
  $stmt->bind_param($types, ...$params);
  $stmt->execute();
  $res = $stmt->get_result();

  if ($res->num_rows > 0) {
    echo "<table>
            <tr>
              <th>ID</th>
              <th>Type</th>
              <th>Category</th>
              <th>Reference ID</th>
              <th>Description</th>
              <th>Amount</th>
              <th>Prev Balance</th>
              <th>Curr Balance</th>
              <th>Direction</th>
              <th>Date</th>
            </tr>";
    while ($row = $res->fetch_assoc()) {
      echo "<tr>
              <td>{$row['id']}</td>
              <td>{$row['type']}</td>
              <td>{$row['category']}</td>
              <td>{$row['reference_id']}</td>
              <td>{$row['description']}</td>
              <td style='text-align:right;'>".number_format($row['amount'],2)."</td>
              <td style='text-align:right;'>".number_format($row['previous_balance'],2)."</td>
              <td style='text-align:right;'>".number_format($row['current_balance'],2)."</td>
              <td>{$row['direction']}</td>
              <td>{$row['created_at']}</td>
            </tr>";
    }
    echo "</table>";

    $totalPages = ceil($total / $limit);
    echo "<div class='pagination'>";
    echo "<button onclick='loadTransactions(" . ($page - 1) . ")' " . ($page <= 1 ? "disabled" : "") . ">Prev</button>";
    echo "<span> Page $page of $totalPages </span>";
    echo "<button onclick='loadTransactions(" . ($page + 1) . ")' " . ($page >= $totalPages ? "disabled" : "") . ">Next</button>";
    echo "</div>";
  } else {
    echo "<p class='no-data'>No transactions found for this filter.</p>";
  }

  $stmt->close();
  $conn->close();
  exit;
}

/* =======================================================
   ✅ 2. EXPORT CSV (unchanged)
   ======================================================= */
if ($action == 'export_csv') {
  $from = $_GET['from'] ?? '';
  $to   = $_GET['to'] ?? '';
  $type = $_GET['type'] ?? '';
  $dir  = $_GET['dir'] ?? '';

  $where = "WHERE DATE(created_at) BETWEEN ? AND ?";
  $params = [$from, $to];
  $types = "ss";

  if (!empty($type)) {
    $where .= " AND type=?";
    $params[] = $type;
    $types .= "s";
  }
  if (!empty($dir)) {
    $where .= " AND direction=?";
    $params[] = $dir;
    $types .= "s";
  }

  $query = "SELECT * FROM transactions $where ORDER BY id DESC";
  $stmt = $conn->prepare($query);
  $stmt->bind_param($types, ...$params);
  $stmt->execute();
  $res = $stmt->get_result();

  header('Content-Type: text/csv');
  header('Content-Disposition: attachment; filename="transactions_report.csv"');

  $out = fopen('php://output', 'w');
  fputcsv($out, ['ID','Type','Category','Reference ID','Description','Amount','Prev Balance','Curr Balance','Direction','Date']);
  while ($row = $res->fetch_assoc()) {
    fputcsv($out, $row);
  }
  fclose($out);
  exit;
}

/* =======================================================
   ✅ 3. SUMMARY TOTALS (fixed Total Sales)
   ======================================================= */
if ($action == 'summary') {
  $from = $_POST['from'] ?? '';
  $to   = $_POST['to'] ?? '';

  $totals = [
    'sales' => 0,
    'purchase' => 0,
    'staff' => 0,
    'expense' => 0,
    'fixed' => 0,
    'loss' => 0,
    'payment' => 0
  ];

  $query = "SELECT category, direction, SUM(amount) AS total 
            FROM transactions 
            WHERE DATE(created_at) BETWEEN ? AND ?
            GROUP BY category, direction";

  $stmt = $conn->prepare($query);
  $stmt->bind_param("ss", $from, $to);
  $stmt->execute();
  $result = $stmt->get_result();

  while ($row = $result->fetch_assoc()) {
    $cat = strtolower(trim($row['category']));
    $total = floatval($row['total']);

    // ✅ Total Sales: dine-in + collection orders (accepting different naming styles)
    if (in_array($cat, ['dine_in', 'dining', 'dining_order', 'collection', 'collection_order', 'takeaway', 'order'])) {
      $totals['sales'] += $total;
    }
    elseif (in_array($cat, ['purchase', 'purchases'])) {
      $totals['purchase'] += $total;
    }
    elseif (in_array($cat, ['staff_cost', 'salary', 'wages'])) {
      $totals['staff'] += $total;
    }
    elseif (in_array($cat, ['expense', 'expenses'])) {
      $totals['expense'] += $total;
    }
    elseif (in_array($cat, ['fixed_expense', 'rent', 'utilities'])) {
      $totals['fixed'] += $total;
    }
    elseif (in_array($cat, ['loss', 'item_loss'])) {
      $totals['loss'] += $total;
    }
    elseif (in_array($cat, ['payment', 'customer_payment'])) {
      $totals['payment'] += $total;
    }
  }

  $income = $totals['sales'] + $totals['payment'];
  $outgoing = $totals['purchase'] + $totals['staff'] + $totals['expense'] + $totals['fixed'] + $totals['loss'];
  $remaining = $income - $outgoing;

  echo json_encode([
    'success' => true,
    'totals' => $totals,
    'remaining' => $remaining
  ]);
  exit;
}
?>
