<?php
include "db.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Transaction Report</title>
<style>
body {
  font-family: "Segoe UI", Arial, sans-serif;
  background: #f4f6f9;
  margin: 0;
  padding: 0;
}
.container {
  max-width: 1250px;
  margin: 30px auto;
  background: #fff;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
}
h2 {
  margin-bottom: 15px;
  border-bottom: 2px solid #007bff;
  display: inline-block;
}
.filter-bar {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  align-items: center;
  margin-bottom: 20px;
}
input, select {
  padding: 8px 10px;
  border: 1px solid #ccc;
  border-radius: 6px;
}
button {
  background: #007bff;
  color: #fff;
  border: none;
  padding: 9px 15px;
  border-radius: 6px;
  cursor: pointer;
  font-weight: 600;
}
button:hover {
  background: #0056b3;
}
table {
  width: 100%;
  border-collapse: collapse;
  font-size: 14px;
}
th, td {
  border: 1px solid #eee;
  padding: 8px;
  text-align: left;
}
th {
  background: #f8f9fa;
}
td:nth-child(6), td:nth-child(7), td:nth-child(8) {
  text-align: right;
}
.no-data {
  text-align: center;
  color: #999;
  font-style: italic;
}
.pagination {
  margin-top: 15px;
  text-align: center;
}
.pagination button {
  margin: 0 5px;
  background: #007bff;
  color: #fff;
  border: none;
  padding: 6px 12px;
  border-radius: 4px;
  cursor: pointer;
}
.pagination button:disabled {
  background: #ccc;
  cursor: not-allowed;
}
.right-buttons {
  margin-left: auto;
}
.summary-cards {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  margin-bottom: 20px;
}
.card {
  flex: 1 1 calc(25% - 15px);
  background: #f8f9fa;
  border-radius: 8px;
  padding: 15px;
  text-align: center;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
.card h4 {
  margin: 0;
  font-size: 15px;
  color: #555;
}
.card p {
  margin: 5px 0 0;
  font-weight: bold;
  font-size: 17px;
}
.card.profit p {
  color: #28a745;
}
.card.loss p {
  color: #dc3545;
}
</style>
</head>

<body>
<div class="container">
  <h2>Transaction Report</h2>

  <div class="filter-bar">
    <label>From:</label>
    <input type="date" id="fromDate">
    <label>To:</label>
    <input type="date" id="toDate">

    <label>Type:</label>
    <select id="typeFilter">
      <option value="">All</option>
      <option value="cash">Cash</option>
      <option value="bank">Bank</option>
    </select>

    <label>Direction:</label>
    <select id="dirFilter">
      <option value="">All</option>
      <option value="in">In</option>
      <option value="out">Out</option>
    </select>

    <button onclick="loadTransactions(1)">Find</button>
    <button onclick="exportCSV()">Export CSV</button>
  </div>

  <div class="summary-cards" id="summarySection" style="display:none;">
    <div class="card"><h4>Total Sales</h4><p id="salesTotal">0</p></div>
    <div class="card"><h4>Total Purchase</h4><p id="purchaseTotal">0</p></div>
    <div class="card"><h4>Staff Cost</h4><p id="staffTotal">0</p></div>
    <div class="card"><h4>Expense</h4><p id="expenseTotal">0</p></div>
    <div class="card"><h4>Fixed Expense</h4><p id="fixedTotal">0</p></div>
    <div class="card"><h4>Item Loss</h4><p id="lossTotal">0</p></div>
    <div class="card"><h4>Payment</h4><p id="paymentTotal">0</p></div>
    <div class="card" id="remainingCard"><h4>Remaining</h4><p id="remainingTotal">0</p></div>
  </div>

  <div id="transactionTable">Please select date range and click Find.</div>
</div>

<script>
let currentPage = 1;

function loadTransactions(page = 1) {
  const from = document.getElementById("fromDate").value;
  const to = document.getElementById("toDate").value;
  const type = document.getElementById("typeFilter").value;
  const dir = document.getElementById("dirFilter").value;

  if (!from || !to) {
    alert("Please select both From and To dates.");
    return;
  }

  currentPage = page;

  // Load Summary first
  fetch("transactions_action.php?action=summary", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `from=${from}&to=${to}`
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      document.getElementById("summarySection").style.display = "flex";

      document.getElementById("salesTotal").innerText = data.totals.sales.toFixed(2);
      document.getElementById("purchaseTotal").innerText = data.totals.purchase.toFixed(2);
      document.getElementById("staffTotal").innerText = data.totals.staff.toFixed(2);
      document.getElementById("expenseTotal").innerText = data.totals.expense.toFixed(2);
      document.getElementById("fixedTotal").innerText = data.totals.fixed.toFixed(2);
      document.getElementById("lossTotal").innerText = data.totals.loss.toFixed(2);
      document.getElementById("paymentTotal").innerText = data.totals.payment.toFixed(2);

      const remaining = data.remaining.toFixed(2);
      const remainingCard = document.getElementById("remainingCard");
      const remainingText = document.getElementById("remainingTotal");

      remainingText.innerText = remaining;
      if (remaining >= 0) {
        remainingCard.classList.add("profit");
        remainingCard.classList.remove("loss");
      } else {
        remainingCard.classList.add("loss");
        remainingCard.classList.remove("profit");
      }
    }
  });

  // Load transactions
  fetch(`transactions_action.php?action=fetch&from=${from}&to=${to}&type=${type}&dir=${dir}&page=${page}`)
    .then(res => res.text())
    .then(data => document.getElementById("transactionTable").innerHTML = data)
    .catch(err => console.error(err));
}

function exportCSV() {
  const from = document.getElementById("fromDate").value;
  const to = document.getElementById("toDate").value;
  const type = document.getElementById("typeFilter").value;
  const dir = document.getElementById("dirFilter").value;

  if (!from || !to) {
    alert("Please select both From and To dates.");
    return;
  }

  window.location = `transactions_action.php?action=export_csv&from=${from}&to=${to}&type=${type}&dir=${dir}`;
}
</script>
</body>
</html>
