<?php
require_once __DIR__ . '/tcpdf/tcpdf.php';

$pdf = new TCPDF('P', 'mm', array(58, 200), true, 'UTF-8', false);
$pdf->SetMargins(2, 2, 2);
$pdf->AddPage();

// Title
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 10, "Q Bistro", 0, 1, 'C');

$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(0, 5, "Lucky Market, Beanibazar", 0, 1, 'C');
$pdf->Cell(0, 5, "Mob: 01341862571", 0, 1, 'C');

$pdf->Ln(2);
$pdf->Cell(0, 0, str_repeat("-", 32), 0, 1, 'C');
$pdf->Ln(2);

// Sample Order
$pdf->Cell(30, 5, "Burger x2", 0, 0, 'L');
$pdf->Cell(20, 5, "£10.00", 0, 1, 'R');

$pdf->Cell(30, 5, "Pizza x1", 0, 0, 'L');
$pdf->Cell(20, 5, "£8.00", 0, 1, 'R');

$pdf->Ln(2);
$pdf->Cell(0, 0, str_repeat("-", 32), 0, 1, 'C');
$pdf->Ln(2);

// Total
$pdf->SetFont('helvetica', 'B', 9);
$pdf->Cell(30, 5, "TOTAL", 0, 0, 'L');
$pdf->Cell(20, 5, "£18.00", 0, 1, 'R');

// Footer
$pdf->Ln(5);
$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(0, 5, "Thank you! Visit again", 0, 1, 'C');

// Output PDF
$pdf->Output('receipt.pdf', 'I'); // 'I' = inline preview
