<?php
session_start();
// $conn = new mysqli("localhost", "root", "", "restaurant_pos");

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";


if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ✅ Handle AJAX requests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    $action = $_POST['action'];
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $name = trim($_POST['supplier_name'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $balance = isset($_POST['balance']) ? floatval($_POST['balance']) : 0;

    if ($action === 'add') {
        $stmt = $conn->prepare("INSERT INTO suppliers (supplier_name, mobile, address, balance) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("sssd", $name, $mobile, $address, $balance);
        $stmt->execute();
        echo json_encode(["status" => "success", "message" => "✅ Supplier added successfully!"]);
        exit;
    } elseif ($action === 'update' && $id > 0) {
        $stmt = $conn->prepare("UPDATE suppliers SET supplier_name=?, mobile=?, address=?, balance=? WHERE id=?");
        $stmt->bind_param("sssdi", $name, $mobile, $address, $balance, $id);
        $stmt->execute();
        echo json_encode(["status" => "success", "message" => "✅ Supplier updated successfully!"]);
        exit;
    } elseif ($action === 'delete' && $id > 0) {
        $stmt = $conn->prepare("DELETE FROM suppliers WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        echo json_encode(["status" => "success", "message" => "🗑️ Supplier deleted successfully!"]);
        exit;
    }
}

// ✅ Fetch suppliers for initial page load
$suppliers = $conn->query("SELECT * FROM suppliers ORDER BY id DESC");
if (!$suppliers) {
    die("SQL Error: " . $conn->error);
}
?>

<style>
body, #mainContent {
  padding: 0 !important;
  margin: 0 !important;
  background: #f9f9f9;
  font-family: 'Segoe UI', Arial, sans-serif;
}
.container {
  display: flex;
  gap: 20px;
  padding: 20px;
  flex-wrap: wrap;
}

/* Left form section */
.form-section {
  flex: 1;
  min-width: 280px;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  padding: 20px;
}
.form-section h2 {
  margin-bottom: 15px;
  font-size: 20px;
  color: #333;
  border-bottom: 2px solid #007bff;
  display: inline-block;
  padding-bottom: 5px;
}
input, textarea {
  width: 100%;
  padding: 10px 12px;
  margin-bottom: 12px;
  border: 1px solid #ccc;
  border-radius: 8px;
  font-size: 15px;
}
input:focus, textarea:focus {
  outline: none;
  border-color: #007bff;
}
button {
  padding: 10px 15px;
  border: none;
  border-radius: 8px;
  color: white;
  font-weight: 600;
  cursor: pointer;
  margin-right: 8px;
  margin-top: 5px;
  transition: all 0.2s ease;
}
button:hover {
  transform: scale(1.05);
}
.add-btn { background: #28a745; }
.update-btn { background: #007bff; }
.delete-btn { background: #dc3545; }

/* Right table section */
.table-section {
  flex: 2;
  min-width: 350px;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  padding: 20px;
}
.table-section h2 {
  margin-bottom: 10px;
  font-size: 20px;
  color: #333;
  border-bottom: 2px solid #1abc9c;
  display: inline-block;
  padding-bottom: 5px;
}
.table-wrapper {
  overflow-x: auto;
}
table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 10px;
}
th, td {
  padding: 10px;
  border-bottom: 1px solid #eee;
  text-align: left;
  font-size: 15px;
}
th {
  background: #f4f4f4;
  color: #333;
  font-weight: bold;
}
tr:hover {
  background-color: #e9f4ff;
  cursor: pointer;
}

/* Notification box */
#msgBox {
  display: none;
  margin: 15px 20px;
  padding: 10px 15px;
  border-radius: 8px;
  font-weight: bold;
}
#msgBox.success { background: #d4edda; color: #155724; }
#msgBox.error { background: #f8d7da; color: #721c24; }

/* Responsive */
@media (max-width: 768px) {
  .container { flex-direction: column; padding: 10px; }
  .form-section, .table-section { width: 100%; }
}
</style>

<div id="msgBox"></div>

<div class="container">
  <!-- Form -->
  <div class="form-section">
    <h2>Manage Supplier</h2>
    <form id="supplierForm">
      <input type="hidden" name="ajax" value="1">
      <input type="hidden" name="id" id="id">

      <label>Supplier Name</label>
      <input type="text" name="supplier_name" id="supplier_name" required>

      <label>Mobile</label>
      <input type="text" name="mobile" id="mobile" required>

      <label>Address</label>
      <textarea name="address" id="address" rows="3"></textarea>

      <label>Balance</label>
      <input type="number" step="0.01" name="balance" id="balance" value="0">

      <div>
        <button type="button" class="add-btn" onclick="submitSupplier('add')">Add</button>
        <button type="button" class="update-btn" onclick="submitSupplier('update')">Update</button>
        <button type="button" class="delete-btn" onclick="submitSupplier('delete')">Delete</button>
      </div>
    </form>
  </div>

  <!-- Table -->
  <div class="table-section">
    <h2>Supplier List</h2>
    <div class="table-wrapper">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Supplier Name</th>
            <th>Mobile</th>
            <th>Address</th>
            <th>Balance</th>
          </tr>
        </thead>
        <tbody id="supplierTableBody">
          <?php while($row = $suppliers->fetch_assoc()): ?>
          <tr onclick="fillForm('<?php echo $row['id']; ?>', '<?php echo htmlspecialchars($row['supplier_name']); ?>', '<?php echo htmlspecialchars($row['mobile']); ?>', '<?php echo htmlspecialchars($row['address']); ?>', '<?php echo $row['balance']; ?>')">
            <td><?php echo $row['id']; ?></td>
            <td><?php echo htmlspecialchars($row['supplier_name']); ?></td>
            <td><?php echo htmlspecialchars($row['mobile']); ?></td>
            <td><?php echo htmlspecialchars($row['address']); ?></td>
            <td>৳<?php echo number_format($row['balance'], 2); ?></td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
function fillForm(id, name, mobile, address, balance) {
  document.getElementById('id').value = id;
  document.getElementById('supplier_name').value = name;
  document.getElementById('mobile').value = mobile;
  document.getElementById('address').value = address;
  document.getElementById('balance').value = balance;
}

async function submitSupplier(action) {
  const form = document.getElementById('supplierForm');
  const formData = new FormData(form);
  formData.append('action', action);

  const response = await fetch('supplier.php', { method: 'POST', body: formData });
  const result = await response.json();

  showMessage(result.message, result.status);
  if (result.status === 'success') {
    refreshSupplierList();
    form.reset();
  }
}

function showMessage(message, status) {
  const msgBox = document.getElementById('msgBox');
  msgBox.textContent = message;
  msgBox.className = status === 'success' ? 'success' : 'error';
  msgBox.style.display = 'block';
  setTimeout(() => msgBox.style.display = 'none', 3000);
}

function refreshSupplierList() {
  fetch('supplier.php')
    .then(res => res.text())
    .then(html => {
      const parser = new DOMParser();
      const doc = parser.parseFromString(html, 'text/html');
      const newTable = doc.getElementById('supplierTableBody');
      document.getElementById('supplierTableBody').innerHTML = newTable.innerHTML;
    });
}
</script>
