<?php
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db   = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";

include "db.php";

header('Content-Type: application/json; charset=utf-8');

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "DB Connection Error"]);
    exit;
}

// Read JSON data from frontend
$data = json_decode(file_get_contents('php://input'), true);

$table_no = intval($data['table'] ?? 0);
$cart     = $data['cart'] ?? [];

if ($table_no <= 0) {
    echo json_encode(["status" => "error", "message" => "Invalid table number"]);
    exit;
}

if (empty($cart)) {
    echo json_encode(["status" => "error", "message" => "Cart is empty!"]);
    exit;
}

try {
    $conn->begin_transaction();

    // 🔄 Clear old cart items for this table (fresh save)
    $delStmt = $conn->prepare("DELETE FROM cart_items WHERE table_no=?");
    $delStmt->bind_param("i", $table_no);
    $delStmt->execute();
    $delStmt->close();

    // 🛒 Insert new cart items
    $itemStmt = $conn->prepare("
        INSERT INTO cart_items 
        (table_no, product_id, product_name, qty, price, total) 
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    if (!$itemStmt) {
        throw new Exception("Prepare failed (cart_items): " . $conn->error);
    }

    foreach ($cart as $item) {
        $pid   = intval($item['id']);
        $pname = (string)$item['name'];
        $qty   = intval($item['qty']);
        $price = floatval($item['price']);
        $total = $qty * $price;

        $itemStmt->bind_param("iisidd", $table_no, $pid, $pname, $qty, $price, $total);

        if (!$itemStmt->execute()) {
            throw new Exception("Insert failed (cart_items): " . $itemStmt->error);
        }
    }
    $itemStmt->close();

    // 🍽️ Update table status to booked
    $updateTable = $conn->prepare("UPDATE dine_in_tables SET status='booked' WHERE id=?");
    $updateTable->bind_param("i", $table_no);
    $updateTable->execute();
    $updateTable->close();

    $conn->commit();

    echo json_encode([
        "status"      => "success",
        "message"     => "Cart saved successfully (table booked)",
        "table"       => $table_no,
       // "receipt_url" => "receipt_pdf.php?table_no={$table_no}" // ✅ Added receipt link
    ]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}

$conn->close();
?>
