<?php
header("Content-Type: application/json");
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db   = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";

include "db.php";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
  echo json_encode(["status" => "error", "message" => "DB connection failed"]);
  exit;
}

$data = json_decode(file_get_contents("php://input"), true);

$name  = $data["customer_name"] ?? "";
$phone = $data["customer_phone"] ?? "";
$cart  = $data["cart"] ?? [];

if (!$name || !$phone || empty($cart)) {
  echo json_encode(["status" => "error", "message" => "Missing data"]);
  exit;
}

$total = 0;
foreach ($cart as $item) {
  $total += $item["price"] * $item["qty"];
}

$stmt = $conn->prepare("INSERT INTO collection_orders (customer_name, customer_phone, order_items, total) VALUES (?,?,?,?)");
$jsonCart = json_encode($cart);
$stmt->bind_param("sssd", $name, $phone, $jsonCart, $total);

if ($stmt->execute()) {
  echo json_encode(["status" => "success", "message" => "Order saved"]);
} else {
  echo json_encode(["status" => "error", "message" => $stmt->error]);
}

$stmt->close();
$conn->close();
