<?php
session_start();
include "db.php";

if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$action = $_REQUEST['action'] ?? '';
$uploadDir = "uploads/staff/";
if (!is_dir($uploadDir)) {
  mkdir($uploadDir, 0777, true);
}

/* ✅ ADD STAFF */
if ($action == "add") {
  $staff_name = $_POST['staff_name'] ?? '';
  $mobile = $_POST['mobile'] ?? '';
  $address = $_POST['address'] ?? '';
  $position = $_POST['position'] ?? ''; // 🆕 New position field
  $photoPath = '';
  $idCardPath = '';

  if (!empty($_FILES['photo']['name'])) {
    $photoName = time() . "_" . basename($_FILES['photo']['name']);
    $target = $uploadDir . $photoName;
    move_uploaded_file($_FILES['photo']['tmp_name'], $target);
    $photoPath = $target;
  }

  if (!empty($_FILES['id_card']['name'])) {
    $idCardName = time() . "_id_" . basename($_FILES['id_card']['name']);
    $target = $uploadDir . $idCardName;
    move_uploaded_file($_FILES['id_card']['tmp_name'], $target);
    $idCardPath = $target;
  }

  $stmt = $conn->prepare("INSERT INTO staff (staff_name, mobile, address, position, photo, id_card) VALUES (?, ?, ?, ?, ?, ?)");
  $stmt->bind_param("ssssss", $staff_name, $mobile, $address, $position, $photoPath, $idCardPath);
  echo $stmt->execute() ? "✅ Staff added successfully!" : "❌ Error adding staff: " . $stmt->error;
  $stmt->close();
  exit;
}

/* ✅ FETCH STAFF LIST */
if ($action == "fetch") {
  $result = $conn->query("SELECT * FROM staff ORDER BY id DESC");
  echo "<table>
    <tr>
      <th>ID</th>
      <th>Name</th>
      <th>Mobile</th>
      <th>Address</th>
      <th>Position</th>
      <th>Photo</th>
      <th>ID Card</th>
      <th>Action</th>
    </tr>";

  if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
      $photo = (!empty($row['photo']) && file_exists($row['photo'])) ? $row['photo'] : 'https://via.placeholder.com/40';
      $id_card = (!empty($row['id_card']) && file_exists($row['id_card'])) ? $row['id_card'] : 'https://via.placeholder.com/40';
      echo "<tr>
        <td>{$row['id']}</td>
        <td>{$row['staff_name']}</td>
        <td>{$row['mobile']}</td>
        <td>{$row['address']}</td>
        <td>{$row['position']}</td>
        <td><img src='{$photo}' alt='Photo' onclick=\"openImageModal('{$photo}')\"></td>
        <td><img src='{$id_card}' alt='ID Card' onclick=\"openImageModal('{$id_card}')\"></td>
        <td><button class='delete-btn' onclick='deleteStaff({$row['id']})'>Delete</button></td>
      </tr>";
    }
  } else {
    echo "<tr><td colspan='8' style='text-align:center;'>No staff found</td></tr>";
  }
  echo "</table>";
  exit;
}

/* ✅ DELETE STAFF */
if ($action == "delete") {
  $id = intval($_GET['id'] ?? 0);
  $result = $conn->query("SELECT photo, id_card FROM staff WHERE id=$id");
  if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if (!empty($row['photo']) && file_exists($row['photo'])) unlink($row['photo']);
    if (!empty($row['id_card']) && file_exists($row['id_card'])) unlink($row['id_card']);
  }
  $conn->query("DELETE FROM staff WHERE id=$id");
  echo "🗑️ Staff deleted successfully!";
  exit;
}

/* ✅ ADD STAFF PAYMENT */
if ($action == "add_payment") {
  $staff_id = $_POST['staff_id'] ?? '';
  $amount = floatval($_POST['amount'] ?? 0);
  $reason = $_POST['reason'] ?? '';
  $payment_type = strtolower(trim($_POST['payment_type'] ?? 'cash'));

  if (empty($staff_id) || $amount <= 0 || empty($reason)) {
    echo json_encode(["success" => false, "message" => "❌ Please fill all payment fields!"]);
    exit;
  }

  $conn->begin_transaction();

  try {
    $res = $conn->query("SELECT staff_name, mobile FROM staff WHERE id = '$staff_id'");
    if (!$res || $res->num_rows == 0) {
      throw new Exception("❌ Invalid staff selected!");
    }

    $staff = $res->fetch_assoc();
    $staff_name = $staff['staff_name'];
    $mobile = $staff['mobile'];

    // ✅ Record payment
    $stmt = $conn->prepare("INSERT INTO staff_payments (staff_id, staff_name, mobile, amount, reason, payment_type, payment_date) VALUES (?, ?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("issdss", $staff_id, $staff_name, $mobile, $amount, $reason, $payment_type);
    $stmt->execute();
    $payment_id = $stmt->insert_id;
    $stmt->close();

    $typeForTx = (in_array($payment_type, ['bank', 'card'])) ? 'bank' : 'cash';
    $direction = 'out';
    $category = 'staff_payment';
    $description = "Staff Payment #{$payment_id} to {$staff_name}";

    // ✅ Get previous balance
    $prevBal = 0.00;
    $balStmt = $conn->prepare("SELECT current_balance FROM transactions WHERE type=? ORDER BY id DESC LIMIT 1");
    $balStmt->bind_param("s", $typeForTx);
    $balStmt->execute();
    $res = $balStmt->get_result();
    if ($res && $res->num_rows > 0) {
      $prevBal = floatval($res->fetch_assoc()['current_balance']);
    }
    $balStmt->close();

    $newBal = $prevBal - $amount;

    // ✅ Insert transaction
    $tx = $conn->prepare("INSERT INTO transactions (type, category, description, amount, previous_balance, current_balance, direction, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())");
    $tx->bind_param("sssddds", $typeForTx, $category, $description, $amount, $prevBal, $newBal, $direction);
    $tx->execute();
    $tx->close();

    // ✅ Update balance
    $balTable = ($typeForTx === 'cash') ? "cash_balance" : "bank_balance";
    $check = $conn->query("SELECT id FROM $balTable WHERE id=1");
    if ($check->num_rows == 0) {
      $conn->query("INSERT INTO $balTable (id, current_balance) VALUES (1, 0)");
    }

    $updateBal = $conn->prepare("UPDATE $balTable SET current_balance = ? WHERE id = 1");
    $updateBal->bind_param("d", $newBal);
    $updateBal->execute();
    $updateBal->close();

    $conn->commit();

    echo json_encode([
      "success" => true,
      "message" => "✅ Staff payment recorded successfully!",
      "payment_id" => $payment_id,
      "staff_name" => $staff_name,
      "type" => $typeForTx,
      "previous_balance" => $prevBal,
      "current_balance" => $newBal
    ]);
  } catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["success" => false, "message" => $e->getMessage()]);
  }

  exit;
}

/* ✅ FETCH PAYMENT HISTORY */
if ($action == "fetch_payments") {
  $result = $conn->query("SELECT * FROM staff_payments ORDER BY id DESC");
  echo "<table>
    <tr>
      <th>ID</th><th>Staff Name</th><th>Mobile</th><th>Amount</th><th>Reason</th><th>Type</th><th>Date</th>
    </tr>";
  if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
      echo "<tr>
        <td>{$row['id']}</td>
        <td>{$row['staff_name']}</td>
        <td>{$row['mobile']}</td>
        <td>{$row['amount']}</td>
        <td>{$row['reason']}</td>
        <td>{$row['payment_type']}</td>
        <td>{$row['payment_date']}</td>
      </tr>";
    }
  } else {
    echo "<tr><td colspan='7' style='text-align:center;'>No payments found</td></tr>";
  }
  echo "</table>";
  exit;
}
?>
