<?php
session_start();
include "db.php";

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
?>

<style>
body, #mainContent {
  margin: 0 !important;
  padding: 0 !important;
  background: #f4f6f9;
  font-family: "Segoe UI", Arial, sans-serif;
}
.container {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  padding: 10px;
}
.left-section {
  flex: 1;
  min-width: 300px;
  display: flex;
  flex-direction: column;
  gap: 20px;
}
.form-section, .payment-section {
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  padding: 20px;
}
.form-section h2, .payment-section h2 {
  margin-bottom: 10px;
  border-bottom: 2px solid #007bff;
  display: inline-block;
}
input, textarea, select {
  width: 100%;
  padding: 10px;
  margin: 6px 0;
  border: 1px solid #ccc;
  border-radius: 8px;
}
button {
  padding: 10px 15px;
  border: none;
  border-radius: 8px;
  color: white;
  font-weight: 600;
  cursor: pointer;
  margin-right: 5px;
}
.add-btn { background: #28a745; }
.update-btn { background: #ffc107; color: black; }
.delete-btn { background: #dc3545; }
.pay-btn { background: #17a2b8; }

.table-section {
  flex: 2;
  min-width: 400px;
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  padding: 20px;
  height: fit-content;
}
.table-section h2 {
  margin-bottom: 10px;
  border-bottom: 2px solid #17a2b8;
  display: inline-block;
}
table {
  width: 100%;
  border-collapse: collapse;
  font-size: 14px;
}
th, td {
  border: 1px solid #eee;
  padding: 8px;
  text-align: left;
}
th { background: #f8f9fa; }
img {
  width: 40px;
  height: 40px;
  object-fit: cover;
  border-radius: 5px;
  cursor: pointer;
}

/* Modal for image */
#imageModal {
  display: none;
  position: fixed;
  z-index: 9999;
  left: 0; top: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.8);
  justify-content: center;
  align-items: center;
}
#imageModal img {
  max-width: 90%;
  max-height: 90%;
  border-radius: 8px;
  box-shadow: 0 0 15px rgba(255,255,255,0.3);
}

@media (max-width: 768px) {
  .container { flex-direction: column; }
}
</style>

<div class="container">
  <div class="left-section">
    <!-- Staff Form -->
    <div class="form-section">
      <h2>Add Staff</h2>
      <form id="staffForm" enctype="multipart/form-data">
        <input type="hidden" name="id" id="staff_id">

        <label>Staff Name</label>
        <input type="text" name="staff_name" id="staff_name" required>

        <label>Mobile</label>
        <input type="text" name="mobile" id="mobile" required>

        <label>Address</label>
        <textarea name="address" id="address" rows="2" required></textarea>

        <label>Position</label>
        <input type="text" name="position" id="position" placeholder="e.g. Chef, Waiter, Manager" required>

        <label>Staff Photo</label>
        <input type="file" name="photo" id="photo" accept="image/*">

        <label>ID Card</label>
        <input type="file" name="id_card" id="id_card" accept="image/*">

        <div style="margin-top:10px;">
          <button type="button" class="add-btn" onclick="addStaff()">Add</button>
          <button type="button" class="update-btn" onclick="updateStaff()">Update</button>
        </div>
      </form>
    </div>

    <!-- Payment Form -->
    <div class="payment-section">
      <h2>Staff Payment</h2>
      <form id="paymentForm">
        <label>Select Staff</label>
        <select name="staff_id" id="staffSelect" onchange="fillStaffInfo()" required>
          <option value="">-- Select Staff --</option>
          <?php
          $res = $conn->query("SELECT id, staff_name, mobile FROM staff");
          while($r = $res->fetch_assoc()){
            echo "<option value='{$r['id']}' data-mobile='{$r['mobile']}'>{$r['staff_name']}</option>";
          }
          ?>
        </select>

        <label>Mobile</label>
        <input type="text" id="staffMobile" readonly>

        <label>Amount</label>
        <input type="number" name="amount" id="amount" required>

        <label>Reason</label>
        <input type="text" name="reason" id="reason" required>

        <label>Payment Type</label>
        <select name="payment_type" id="payment_type" required>
          <option value="cash">Cash</option>
          <option value="card">Card</option>
        </select>

        <div style="margin-top:10px;">
          <button type="button" class="pay-btn" onclick="addPayment()">Pay</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Right: Staff Table -->
  <div class="table-section">
    <h2>Staff List</h2>
    <div id="staffTableContainer">Loading staff...</div>
    <h2 style="margin-top:20px;">Payment History</h2>
    <div id="paymentTableContainer">Loading payments...</div>
  </div>
</div>

<div id="imageModal" onclick="closeImageModal()">
  <img id="modalImage" src="">
</div>

<script>
loadStaffTable();
loadPaymentTable();

function loadStaffTable() {
  fetch("staff_actions.php?action=fetch")
  .then(res => res.text())
  .then(data => document.getElementById("staffTableContainer").innerHTML = data);
}

function loadPaymentTable() {
  fetch("staff_actions.php?action=fetch_payments")
  .then(res => res.text())
  .then(data => document.getElementById("paymentTableContainer").innerHTML = data);
}

function addStaff() {
  let formData = new FormData(document.getElementById("staffForm"));
  formData.append("action", "add");

  fetch("staff_actions.php", { method: "POST", body: formData })
  .then(res => res.text())
  .then(msg => {
    alert(msg);
    document.getElementById("staffForm").reset();
    loadStaffTable();
  });
}

function fillStaffInfo() {
  let sel = document.getElementById("staffSelect");
  let mobile = sel.options[sel.selectedIndex].getAttribute("data-mobile") || "";
  document.getElementById("staffMobile").value = mobile;
}

function addPayment() {
  let formData = new FormData(document.getElementById("paymentForm"));
  formData.append("action", "add_payment");

  fetch("staff_actions.php", { method: "POST", body: formData })
  .then(res => res.text())
  .then(msg => {
    alert(msg);
    document.getElementById("paymentForm").reset();
    loadPaymentTable();
  });
}

function deleteStaff(id) {
  if(!confirm("Are you sure to delete this staff?")) return;
  fetch("staff_actions.php?action=delete&id=" + id)
  .then(res => res.text())
  .then(msg => {
    alert(msg);
    loadStaffTable();
  });
}

function openImageModal(src) {
  const modal = document.getElementById("imageModal");
  const modalImg = document.getElementById("modalImage");
  modalImg.src = src;
  modal.style.display = "flex";
}

function closeImageModal() {
  document.getElementById("imageModal").style.display = "none";
}
</script>
