<?php
// ✅ Always return JSON
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set("display_errors", 0); // don't show HTML errors to browser
ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/php_errors.log"); // log errors here

// $host = "localhost";
// $user = "root";
// $pass = "";
// $db   = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";


$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    echo json_encode(["status"=>"error","message"=>"DB connection failed: ".$conn->connect_error]);
    exit;
}

$table = intval($_POST['table'] ?? 0);
$type  = $_POST['type'] ?? 'dinein';

// ✅ Insert new order
$stmt = $conn->prepare("INSERT INTO orders (table_no, order_type, order_status, created_at) VALUES (?, ?, 'booked', NOW())");

if (!$stmt) {
    echo json_encode(["status"=>"error","message"=>"SQL prepare failed: ".$conn->error]);
    exit;
}

$stmt->bind_param("is", $table, $type);
$ok = $stmt->execute();
$order_id = $stmt->insert_id;
$stmt->close();

if (!$ok || !$order_id) {
    echo json_encode(["status"=>"error","message"=>"Order insert failed: ".$conn->error]);
    exit;
}

// ✅ Respond JSON only
echo json_encode([
    "status" => "success",
    "message" => "Order saved successfully",
    "order_id" => $order_id,
    "receipt_url" => "receipt.php?order_id=".$order_id
]);

$conn->close();
