<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include "db.php";
header("Content-Type: application/json");

// Read JSON input
$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (!$data || !isset($data['items']) || count($data['items']) === 0) {
    echo json_encode(["status" => "error", "message" => "No items found."]);
    exit;
}

$items = $data['items'];
$total = 0;

// Calculate total
foreach ($items as $it) {
    $qty   = intval($it['qty']);
    $price = floatval($it['price']);
    $total += $qty * $price;
}

// Create / Update rest_orders table with total column
$conn->query("
    CREATE TABLE IF NOT EXISTS rest_orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        total DECIMAL(10,2) DEFAULT 0,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
");

// Create rest_order_items table if not exists
$conn->query("
    CREATE TABLE IF NOT EXISTS rest_order_items (
        id INT AUTO_INCREMENT PRIMARY KEY,
        rest_order_id INT,
        product_id INT,
        product_name VARCHAR(255),
        qty INT,
        price DECIMAL(10,2),
        total DECIMAL(10,2),
        FOREIGN KEY (rest_order_id) REFERENCES rest_orders(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
");

// Insert order with total
$stmtOrder = $conn->prepare("
    INSERT INTO rest_orders (total) 
    VALUES (?)
");
$stmtOrder->bind_param("d", $total);
$stmtOrder->execute();
$rest_order_id = $stmtOrder->insert_id;
$stmtOrder->close();

// Insert items
$stmt = $conn->prepare("
    INSERT INTO rest_order_items (rest_order_id, product_id, product_name, qty, price, total) 
    VALUES (?,?,?,?,?,?)
");

foreach ($items as $it) {
    $pid   = intval($it['id']);
    $name  = $conn->real_escape_string($it['name']);
    $qty   = intval($it['qty']);
    $price = floatval($it['price']);
    $item_total = $qty * $price;
    $stmt->bind_param("iisidd", $rest_order_id, $pid, $name, $qty, $price, $item_total);
    $stmt->execute();
}
$stmt->close();

// Return success + redirect to print receipt
echo json_encode([
    "status" => "success",
    "message" => "Rest order saved!",
    "rest_order_id" => $rest_order_id,
    "redirect" => "print_rest_receipt.php?id=" . $rest_order_id
]);
?>
