<?php
include "db.php";

$data = json_decode(file_get_contents("php://input"), true);
$name = trim($data['name'] ?? '');
$source = trim($data['source'] ?? '');

if ($name == '' || $source == '') {
  echo json_encode(['success' => false, 'message' => 'Missing fields']);
  exit;
}

$stmt = $conn->prepare("INSERT INTO orderpad_product (p_product_name, source) VALUES (?, ?)");
$stmt->bind_param("ss", $name, $source);

if ($stmt->execute()) {
  echo json_encode(['success' => true]);
} else {
  echo json_encode(['success' => false, 'message' => $conn->error]);
}
