<?php
include "db.php";

$data = json_decode(file_get_contents("php://input"), true);

$id = $data['id'] ?? '';
$name = $data['name'] ?? '';
$source = $data['source'] ?? '';
$qty = $data['qty'] ?? '';

if ($name == '' || $source == '' || $qty == '') {
    echo json_encode(['success' => false, 'message' => 'Missing fields']);
    exit;
}

// make sure we don’t cast qty to int — store it exactly as typed
$stmt = $conn->prepare("INSERT INTO orderpad_order_productlist (product_id, product_name, source, qty) VALUES (?, ?, ?, ?)");
$stmt->bind_param("isss", $id, $name, $source, $qty);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $conn->error]);
}
?>
