<?php 
session_start(); 
include "db.php"; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>♻️ Remining Items</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body, html {
  margin: 0; padding: 0; height: 100%;
  font-family: Arial, sans-serif;
}
.order-page {
  display: flex; height: 100vh;
}

/* LEFT SIDE: Products */
.products-section {
  flex: 2; display: flex; flex-direction: column;
  border-right: 1px solid #ddd; overflow: hidden;
}
.products-header {
  padding: 8px 10px; background: #f8f8f8;
  border-bottom: 1px solid #ddd; position: sticky; top: 0; z-index: 5;
}
.products-container {
  flex: 1; overflow-y: auto; padding: 6px;
  display: grid; grid-template-columns: repeat(6, 1fr); gap: 4px;
}
.product-card {
  border: 1px solid #ddd; padding: 2px;
  border-radius: 4px; text-align: center;
  cursor: pointer; background: #fff; transition: 0.15s;
  font-size: 10px;
}
.product-card:hover {
  background: #f1f1f1; transform: scale(1.03);
}
.product-card img {
  width: 100%; height: 55px; object-fit: cover;
  border-radius: 3px; margin-bottom: 1px;
}
.product-card h4 {
  font-size: 10px; margin: 1px 0; line-height: 1.1; color: #333;
}
.product-card p {
  font-size: 10px; margin: 0; font-weight: bold; color: #444;
}

/* RIGHT SIDE: Cart */
.cart {
  flex: 1; display: flex; flex-direction: column;
  background: #fafafa; border-left: 1px solid #ddd;
  height: 100vh; position: sticky; top: 0; padding: 8px;
}
.cart h3 { margin: 0 0 8px; font-size: 14px; }
.cart-items-container {
  flex: 1; overflow-y: auto; margin-bottom: 10px;
}
.cart-items-container table {
  width: 100%; border-collapse: collapse; font-size: 11px;
}
.cart-items-container th, .cart-items-container td {
  border: 1px solid #ccc; padding: 2px; text-align: center;
}
.cart-footer {
  margin-top: auto; padding-top: 5px; border-top: 1px solid #ddd; background: #fff;
}
button {
  padding: 7px 10px; border: none; border-radius: 4px; cursor: pointer;
}
#goCheckoutBtn {
  background: #007bff; color: white; width: 100%;
  font-size: 13px; padding: 9px;
}
#goCheckoutBtn:hover {
  background: #0069d9;
}

/* Responsive tweaks */
@media (max-width: 1200px) {
  .products-container { grid-template-columns: repeat(5, 1fr); }
}
@media (max-width: 1000px) {
  .products-container { grid-template-columns: repeat(4, 1fr); }
}
@media (max-width: 800px) {
  .products-container { grid-template-columns: repeat(3, 1fr); }
}
@media (max-width: 600px) {
  .products-container { grid-template-columns: repeat(2, 1fr); }
}
</style>
</head>

<body>
<div class="order-page">

  <!-- LEFT SIDE: Product list -->
  <div class="products-section">
    <div class="products-header">
      <h2>♻️ Remining Items</h2>
    </div>

    <div class="products-container">
      <?php 
      $res = $conn->query("SELECT id, name, price, image FROM products");
      while($row = $res->fetch_assoc()){
        $img = $row['image'] ? $row['image'] : 'no_image.png';
        echo "
          <div class='product-card' 
               data-id='{$row['id']}' 
               data-name=\"{$row['name']}\" 
               data-price='{$row['price']}'>
            <img src='uploads/{$img}' alt='{$row['name']}'>
            <h4>{$row['name']}</h4>
            <p>৳" . number_format($row['price'], 2) . "</p>
          </div>
        ";
      } 
      ?>
    </div>
  </div>

  <!-- RIGHT SIDE: Cart -->
  <div class="cart">
    <h3>🛒 Selected Items</h3>
    <div class="cart-items-container">
      <table id="cartTable">
        <thead>
          <tr><th>Item</th><th>Qty</th><th>Price</th><th>Total</th><th>❌</th></tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
    <div class="cart-footer">
      <h3>Total: ৳<span id="grandTotal">0.00</span></h3>
      <button id="goCheckoutBtn">✅ Submit Remining Items</button>
    </div>
  </div>
</div>

<script>
let cart = [];

// ✅ Update Cart Table
function updateCartTable() {
  const tbody = document.querySelector("#cartTable tbody");
  tbody.innerHTML = "";
  let grandTotal = 0;

  cart.forEach((item, i) => {
    const total = item.price * item.qty;
    grandTotal += total;
    const row = document.createElement("tr");
    row.innerHTML = `
      <td>${item.name}</td>
      <td>${item.qty}</td>
      <td>৳${item.price.toFixed(2)}</td>
      <td>৳${total.toFixed(2)}</td>
      <td><button onclick="removeFromCart(${i})">❌</button></td>
    `;
    tbody.appendChild(row);
  });
  document.getElementById("grandTotal").innerText = grandTotal.toFixed(2);
}

function removeFromCart(index) {
  cart.splice(index, 1);
  updateCartTable();
}

function addToCart(product) {
  const existing = cart.find(i => i.id === product.id);
  if (existing) {
    existing.qty += 1;
  } else {
    cart.push({ ...product, qty: 1 });
  }
  updateCartTable();
}

// ✅ Product click
document.querySelectorAll(".product-card").forEach(card => {
  card.addEventListener("click", () => {
    const product = {
      id: parseInt(card.dataset.id),
      name: card.dataset.name,
      price: parseFloat(card.dataset.price)
    };
    addToCart(product);
  });
});

// ✅ Submit Rest Items to Database
document.getElementById("goCheckoutBtn").onclick = function() {
  if (cart.length === 0) {
    alert("Please add some items first.");
    return;
  }

  fetch("save_rest_items.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ items: cart })
  })
  .then(res => res.json())
  .then(data => {
    if (data.status === "success") {
      // ✅ Redirect to print receipt automatically
      window.location.href = data.redirect;
    } else {
      alert("❌ Error: " + data.message);
    }
  })
  .catch(err => {
    alert("❌ Network error: " + err);
  });
};
</script>

</body>
</html>
