<?php
session_start();
include "db.php";
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$date = date('Y-m-d');
$day = date('l');

// Fetch totals
$total_sales = 0;
$total_collection = 0;
$total_dining = 0;
$total_delivery = 0;
$total_purchases = 0;
$total_staff_cost = 0;
$total_expenses = 0;
$total_remaining_loss = 0;
$total_cash_sales = 0;
$total_bank_sales = 0;
$total_supplier_payments = 0;
$total_fixed_expense = 0;

// ===================== SALES =====================
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_sales = $row['total'] ?? 0;

// ===================== COLLECTION ORDERS =====================
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date' AND order_type = 'collection'");
if ($res && $row = $res->fetch_assoc()) $total_collection = $row['total'] ?? 0;

// ===================== DINING ORDERS =====================
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date' AND order_type = 'dinein'");
if ($res && $row = $res->fetch_assoc()) $total_dining = $row['total'] ?? 0;

// ===================== DELIVERY ORDERS =====================
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date' AND order_type = 'delivery'");
if ($res && $row = $res->fetch_assoc()) $total_delivery = $row['total'] ?? 0;

// ===================== PURCHASE =====================
$res = $conn->query("SELECT SUM(subtotal) AS total FROM purchases WHERE DATE(purchase_date) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_purchases = $row['total'] ?? 0;

// ===================== STAFF COST =====================
$res = $conn->query("SELECT SUM(amount) AS total FROM staff_payments WHERE DATE(payment_date) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_staff_cost = $row['total'] ?? 0;

// ===================== EXPENSE =====================
$res = $conn->query("SELECT SUM(amount) AS total FROM expenses WHERE DATE(created_at) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_expenses = $row['total'] ?? 0;

// ===================== REMAINING LOSS =====================
$res = $conn->query("SELECT SUM(total) AS total FROM rest_orders WHERE DATE(created_at) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_remaining_loss = $row['total'] ?? 0;

// ===================== CASH SALES =====================
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date' AND payment_type = 'cash'");
if ($res && $row = $res->fetch_assoc()) $total_cash_sales = $row['total'] ?? 0;

// ===================== BANK SALES =====================
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date' AND payment_type = 'bank'");
if ($res && $row = $res->fetch_assoc()) $total_bank_sales = $row['total'] ?? 0;

// ===================== FIXED EXPENSE =====================
$res = $conn->query("SELECT SUM(amount) AS total FROM fixed_expense_list WHERE DATE(created_at) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_fixed_expense = $row['total'] ?? 0;

// ===================== SUPPLIER PAYMENTS =====================
$res = $conn->query("SELECT SUM(pay_amount) AS total FROM payments WHERE DATE(created_at) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_supplier_payments = $row['total'] ?? 0;

// ===================== NET PROFIT =====================
$net = $total_sales - (
    $total_purchases +
    $total_staff_cost +
    $total_expenses +
    $total_remaining_loss +
    $total_fixed_expense +
    $total_supplier_payments
);

?>

<style>
body, #mainContent {
    margin: 0 !important;
    padding: 0 !important;
    background: #f4f6f9;
    font-family: "Segoe UI", Arial, sans-serif;
}
.report-container {
    background: #fff;
    margin: 20px auto;
    padding: 30px;
    max-width: 800px;
    border-radius: 12px;
    box-shadow: 0 3px 8px rgba(0,0,0,0.1);
    text-align: center;
}
.report-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    margin-top: 20px;
}
.card {
    background: #f8f9fa;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
.summary {
    margin-top: 30px;
    background: #e9f7ef;
    padding: 15px;
    border-radius: 8px;
    color: #155724;
    font-weight: bold;
    font-size: 18px;
}
.print-btn {
    margin-top: 20px;
    background: #007bff;
    color: white;
    border: none;
    padding: 12px 20px;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
}
.print-btn:hover {
    background: #0056b3;
}

/* PRODUCT REPORT TABLE */
.product-report {
    margin-top: 40px;
    background: #fff;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}
.product-report table {
    width: 100%;
    border-collapse: collapse;
}
.product-report th {
    background: #007bff;
    color: #fff;
    padding: 10px;
}
.product-report td {
    padding: 10px;
    border: 1px solid #ddd;
}
</style>

<div class="report-container">
    <h1>🍽️ QBistro</h1>
    <h2>Daily Report</h2>
    <p><b>Date:</b> <?= $date ?> | <b>Day:</b> <?= $day ?></p>

    <div class="report-grid">
        <div class="card"><h3>Total Sales</h3><p>৳<?= number_format($total_sales,2) ?></p></div>
        <div class="card"><h3>Collection Orders</h3><p>৳<?= number_format($total_collection, 2) ?></p></div>
        <div class="card"><h3>Dining Orders</h3><p>৳<?= number_format($total_dining, 2) ?></p></div>
        <div class="card"><h3>Delivery Orders</h3><p>৳<?= number_format($total_delivery, 2) ?></p></div>
        <div class="card"><h3>Total Purchase</h3><p>৳<?= number_format($total_purchases,2) ?></p></div>
        <div class="card"><h3>Total Staff Cost</h3><p>৳<?= number_format($total_staff_cost,2) ?></p></div>
        <div class="card"><h3>Total Expense</h3><p>৳<?= number_format($total_expenses,2) ?></p></div>
        <div class="card"><h3>Remaining Loss</h3><p>৳<?= number_format($total_remaining_loss,2) ?></p></div>
        <div class="card"><h3>Cash Sales</h3><p>৳<?= number_format($total_cash_sales,2) ?></p></div>
        <div class="card"><h3>Bank Sales</h3><p>৳<?= number_format($total_bank_sales,2) ?></p></div>

        <div class="card"><h3>Fixed Expenses</h3><p>৳<?= number_format($total_fixed_expense,2) ?></p></div>
        <div class="card"><h3>Supplier Payments</h3><p>৳<?= number_format($total_supplier_payments,2) ?></p></div>
    </div>

    <div class="summary">
        Net Profit / Loss:
        <?= $net >= 0 ? "<span style='color:green;'>৳".number_format($net,2)."</span>" : "<span style='color:red;'>-৳".number_format(abs($net),2)."</span>" ?>
    </div>

    <button class="print-btn" onclick="window.print()">Print</button>
</div>

<!-- ===================== PRODUCT REPORT SECTION ===================== -->

<div class="product-report">
    <h2>📊 Product Sales Report (<?= $date ?>)</h2>

<?php
$rows = [];
$startDate = $date;
$endDate = $date;

$query = "
SELECT 
    p.id AS product_id, 
    p.name AS product_name, 
    oi.price, 
    SUM(oi.qty) AS total_qty, 
    SUM(oi.total) AS total_amount
FROM order_items oi
INNER JOIN orders o ON oi.order_id = o.id
INNER JOIN products p ON oi.product_name = p.name
WHERE DATE(o.created_at) BETWEEN '$startDate' AND '$endDate'
GROUP BY p.id, p.name, oi.price
ORDER BY p.id ASC
";

$res = $conn->query($query);
if ($res) while ($r = $res->fetch_assoc()) $rows[] = $r;
?>

<?php if (!empty($rows)): ?>
<table>
    <thead>
        <tr>
            <th>SL</th>
            <th>Product</th>
            <th>Price (৳)</th>
            <th>Qty</th>
            <th>Total (৳)</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $sl = 1; 
        $grand = 0;
        foreach ($rows as $r):  
            $grand += $r['total_amount'];
        ?>
        <tr>
            <td><?= $sl++ ?></td>
            <td><?= $r['product_name'] ?></td>
            <td><?= number_format($r['price'],2) ?></td>
            <td><?= $r['total_qty'] ?></td>
            <td><?= number_format($r['total_amount'],2) ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="4"><b>Grand Total</b></td>
            <td><b>৳<?= number_format($grand,2) ?></b></td>
        </tr>
    </tfoot>
</table>

<?php else: ?>
<p style="text-align:center;color:#666;">No product sales found today.</p>
<?php endif; ?>

</div>
