<?php
include "db.php";
date_default_timezone_set("Asia/Dhaka");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Remaining Items</title>
    <style>
        body { font-family: Arial; background: #f2f2f2; padding: 20px; }
        .order-row {
            background: #fff;
            padding: 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0,0,0,0.1);
        }
        .order-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .view-btn {
            padding: 6px 12px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .view-btn:hover { background: #0056b3; }

        .items-box {
            display: none;
            background: #fff;
            margin-top: 10px;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #007bff;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }
        th, td {
            padding: 8px;
            border-bottom: 1px solid #ddd;
        }
        th { background: #eee; }
    </style>

    <script>
        function toggleItems(id) {
            let box = document.getElementById("items_" + id);
            box.style.display = box.style.display === "none" ? "block" : "none";
        }
    </script>
</head>
<body>

<h1>Remaining Items</h1>

<?php
$orders = $conn->query("SELECT * FROM rest_orders ORDER BY id DESC");

while ($o = $orders->fetch_assoc()) {
    $oid   = $o['id'];
    $time  = $o['created_at'];
    $total = number_format($o['total'], 2);

    echo "
    <div class='order-row'>
        <div class='order-header'>
            <div>
                <b>Order #$oid</b><br>
                Total: $total<br>
                <small>Created: $time</small>
            </div>
            <button class='view-btn' onclick='toggleItems($oid)'>View</button>
        </div>

        <div class='items-box' id='items_$oid'>
            <h3>Order Items</h3>
            <table>
                <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Total</th>
                </tr>";

    // Get items
    $it = $conn->prepare("SELECT * FROM rest_order_items WHERE rest_order_id=?");
    $it->bind_param("i", $oid);
    $it->execute();
    $items = $it->get_result();

    while ($r = $items->fetch_assoc()) {
        echo "
            <tr>
                <td>{$r['product_name']}</td>
                <td>{$r['qty']}</td>
                <td>".number_format($r['price'],2)."</td>
                <td>".number_format($r['total'],2)."</td>
            </tr>";
    }

    echo "
            </table>
        </div>
    </div>";
}
?>

</body>
</html>
