<?php
include "db.php";

$orderId = intval($_GET['id'] ?? 0);
if (!$orderId) {
  die("❌ Invalid order");
}

// ✅ Fetch order
$orderRes = $conn->query("SELECT * FROM orders WHERE id = $orderId AND order_type='collection' LIMIT 1");
$order = $orderRes->fetch_assoc();
if (!$order) {
  die("❌ Order not found");
}

// ✅ Fetch order items
$items = $conn->query("SELECT * FROM order_items WHERE order_id = $orderId");

// ✅ Build ESC/POS-style text
$receipt  = "         Q Bistro\n";
$receipt .= "Lucky Market, Beanibazar\n";
$receipt .= "Mob: 01341862571\n";
$receipt .= "--------------------------------\n";
$receipt .= "Order No: " . $orderId . "\n";
$receipt .= "Type: Collection\n";

if (!empty($order['customer_name'])) {
    $receipt .= "Customer: " . $order['customer_name'] . "\n";
}
if (!empty($order['customer_phone'])) {
    $receipt .= "Phone: " . $order['customer_phone'] . "\n";
}

$receipt .= "Payment: " . $order['payment_type'] . "\n";
$receipt .= "Date: " . date("d-m-Y H:i", strtotime($order['created_at'])) . "\n";
$receipt .= "--------------------------------\n";

while ($row = $items->fetch_assoc()) {
    $name  = substr($row['product_name'], 0, 18);
    $qty   = "x" . $row['qty'];
    $price = "" . number_format($row['total'], 2);
    $line  = str_pad($name . " " . $qty, 22) . str_pad($price, 10, ' ', STR_PAD_LEFT);
    $receipt .= $line . "\n";
}

$receipt .= "--------------------------------\n";
$receipt .= sprintf("%-20s %10s\n", "Subtotal:", "" . number_format($order['subtotal'], 2));

if ($order['discount'] > 0)
    $receipt .= sprintf("%-20s %10s\n", "Discount:", "-" . number_format($order['discount'], 2));

if ($order['tip'] > 0)
    $receipt .= sprintf("%-20s %10s\n", "Tip:", "" . number_format($order['tip'], 2));

$receipt .= "--------------------------------\n";
$receipt .= sprintf("%-20s %10s\n", "TOTAL:", "" . number_format($order['final_total'], 2));
$receipt .= "\nThank you! Visit again\n\n\n";

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Printing Receipt...</title>
<style>
body {
  font-family: monospace;
  white-space: pre;
  text-align: center;
  padding: 50px;
}
button {
  background: #007bff;
  color: white;
  border: none;
  padding: 10px 20px;
  border-radius: 8px;
  font-size: 16px;
  cursor: pointer;
}
button:hover {
  background: #0056b3;
}
</style>
</head>
<body>
<h3>🖨️ Printing Receipt via Bluetooth...</h3>
<p>If printing doesn’t start automatically, click below 👇</p>
<button id="printBtn">Print Now</button>

<script>
document.getElementById("printBtn").onclick = () => {
  const text = <?php echo json_encode($receipt, JSON_UNESCAPED_UNICODE); ?>;

  // ✅ Convert text to Base64 (RawBT supports this)
  const base64 = btoa(unescape(encodeURIComponent(text)));

  // ✅ Open RawBT app using Android intent scheme
  const intentUrl =
    "intent:" + encodeURIComponent("base64," + base64) +
    "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end";

  window.location.href = intentUrl;

  // Redirect back to dashboard after 5 seconds
  setTimeout(() => {
    window.location.href = "dashboard.php";
  }, 5000);
};

// ✅ Auto-click for convenience (some browsers may block)
window.onload = () => {
  setTimeout(() => {
    document.getElementById("printBtn").click();
  }, 800);
};
</script>
</body>
</html>
