<?php include "db.php"; ?>
<!DOCTYPE html>
<html lang="en">
    
<head>
  <meta charset="UTF-8">
  <title>Purchase Product Management (New)</title>
  <style>
    body {
      font-family: "Poppins", sans-serif;
      background: #f9fafb;
      margin: 0;
      padding: 0;
    }
    .container {
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      padding: 20px;
      gap: 20px;
      flex-wrap: wrap;
    }
    .form-section, .table-section {
      background: white;
      border-radius: 10px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
      padding: 20px;
      flex: 1;
      min-width: 300px;
    }
    .form-section {
      max-width: 350px;
    }
    input[type="text"], select {
      width: 100%;
      padding: 10px;
      margin: 10px 0;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 14px;
    }
    button {
      padding: 8px 14px;
      margin: 5px;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      color: white;
      font-weight: bold;
      font-size: 14px;
    }
    button.add { background-color: #16a34a; }
    button.update { background-color: #2563eb; }
    button.delete { background-color: #dc2626; }
    button.clear { background-color: #6b7280; }
    table {
      width: 100%;
      border-collapse: collapse;
      font-size: 14px;
    }
    table th, table td {
      border: 1px solid #ddd;
      padding: 8px;
      text-align: left;
    }
    table th {
      background: #f3f4f6;
    }
    tr:hover {
      background: #f9fafb;
      cursor: pointer;
    }

    /* Responsive for mobile/tablet */
    @media (max-width: 768px) {
      .container {
        flex-direction: column;
        padding: 10px;
      }
      .form-section, .table-section {
        width: 100%;
      }
    }
  </style>
</head>
<body>

<div class="container">
  <!-- Left Side: Form -->
  <div class="form-section">
    <h3>🛒 Manage Purchase Products</h3>
    <input type="hidden" id="product_id">

    <label>Product Name</label>
    <input type="text" id="p_product_name" placeholder="Enter product name">

    <label>Product Type</label>
    <select id="product_type">
      <option value="Manage Fridge">Manage Fridge</option>
      <option value="Solid Product">Solid Product</option>
      <option value="Unmanaged Stock">Unmanaged Stock</option>
    </select>

    <div>
      <button class="add" onclick="addProduct()">Add</button>
      <button class="update" onclick="updateProduct()">Update</button>
      <button class="delete" onclick="deleteProduct()">Delete</button>
      <button class="clear" onclick="clearForm()">Clear</button>
    </div>
  </div>

  <!-- Right Side: Product List -->
  <div class="table-section">
    <h3>📋 Product List</h3>
    <table id="productTable">
      <thead>
        <tr>
          <th>ID</th>
          <th>Product Name</th>
          <th>Type</th>
          <th>Created At</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
const API_URL = window.location.origin + "/reasturant-pos/pu_product_action.php";

window.onload = function() {
  loadProducts();
};

/* ✅ Fetch products */
function loadProducts() {
  fetch(`${API_URL}?action=fetch`)
    .then(res => res.json())
    .then(data => {
      const tbody = document.querySelector("#productTable tbody");
      tbody.innerHTML = '';
      if (!data || data.length === 0) {
        tbody.innerHTML = '<tr><td colspan="4" style="text-align:center;">No products found</td></tr>';
        return;
      }
      data.forEach(row => {
        const tr = document.createElement("tr");
        tr.innerHTML = `
          <td>${row.id}</td>
          <td>${row.p_product_name}</td>
          <td>${row.product_type}</td>
          <td>${row.created_at}</td>
        `;
        tr.onclick = () => selectRow(row);
        tbody.appendChild(tr);
      });
    })
    .catch(err => console.error("Error fetching products:", err));
}

/* ✅ Select product for edit/delete */
function selectRow(row) {
  document.getElementById("product_id").value = row.id;
  document.getElementById("p_product_name").value = row.p_product_name;
  document.getElementById("product_type").value = row.product_type;
}

/* ✅ Add new product */
function addProduct() {
  const name = document.getElementById("p_product_name").value.trim();
  const type = document.getElementById("product_type").value;
  if (!name) return alert("Please enter a product name");

  fetch(API_URL, {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `action=add&p_product_name=${encodeURIComponent(name)}&product_type=${encodeURIComponent(type)}`
  })
  .then(res => res.text())
  .then(msg => {
    alert(msg);
    clearForm();
    loadProducts();
  });
}

/* ✅ Update product */
function updateProduct() {
  const id = document.getElementById("product_id").value;
  const name = document.getElementById("p_product_name").value.trim();
  const type = document.getElementById("product_type").value;
  if (!id || !name) return alert("Select a product first");

  fetch(API_URL, {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `action=update&id=${id}&p_product_name=${encodeURIComponent(name)}&product_type=${encodeURIComponent(type)}`
  })
  .then(res => res.text())
  .then(msg => {
    alert(msg);
    clearForm();
    loadProducts();
  });
}

/* ✅ Delete product */
function deleteProduct() {
  const id = document.getElementById("product_id").value;
  if (!id) return alert("Select a product to delete");
  if (!confirm("Are you sure you want to delete this product?")) return;

  fetch(API_URL, {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `action=delete&id=${id}`
  })
  .then(res => res.text())
  .then(msg => {
    alert(msg);
    clearForm();
    loadProducts();
  });
}

/* ✅ Clear form fields */
function clearForm() {
  document.getElementById("product_id").value = '';
  document.getElementById("p_product_name").value = '';
  document.getElementById("product_type").value = 'Manage Fridge';
      loadProducts();

}
</script>

</body>
</html>
