<?php
session_start();
// $conn = new mysqli("localhost", "root", "", "restaurant_pos");

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$suppliers = $conn->query("SELECT id, supplier_name, balance FROM suppliers ORDER BY supplier_name ASC");
if (!$suppliers) {
    die("SQL Error: " . $conn->error);
}
?>

<style>
body, #mainContent {
  margin: 0 !important;
  padding: 0 !important;
  background: #f4f6f9;
  font-family: "Segoe UI", Arial, sans-serif;
}
.container {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  padding: 20px;
}

/* Left form section */
.form-section {
  flex: 1;
  min-width: 300px;
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  padding: 20px;
}
.form-section h2 {
  margin-bottom: 15px;
  border-bottom: 2px solid #007bff;
  display: inline-block;
  color: #333;
}
input {
  width: 100%;
  padding: 8px 10px;
  margin-bottom: 10px;
  border: 1px solid #ccc;
  border-radius: 6px;
  font-size: 14px;
}
button {
  padding: 8px 12px;
  border: none;
  border-radius: 8px;
  color: white;
  font-weight: 600;
  cursor: pointer;
  transition: background 0.2s, transform 0.2s;
}
button:hover { transform: scale(1.05); }
.add-btn { background: #28a745; }
.purchase-btn { background: #007bff; width: 100%; margin-top: 10px; }

/* Right cart section */
.cart-section {
  flex: 2;
  min-width: 350px;
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  padding: 20px;
}
.cart-section h2 {
  border-bottom: 2px solid #17a2b8;
  display: inline-block;
  color: #333;
}
table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 10px;
}
th, td {
  padding: 8px;
  border-bottom: 1px solid #eee;
  text-align: left;
  font-size: 14px;
}
th { background: #f8f9fa; }
tfoot td { font-weight: bold; }

/* Compact payment area */
.summary {
  margin-top: 15px;
  padding: 10px;
  background: #f7f7f7;
  border-radius: 8px;
}
.summary h3 {
  font-size: 16px;
  margin-bottom: 10px;
  color: #333;
}
.summary label {
  font-size: 13px;
  font-weight: 600;
}
.summary input, .summary select {
  width: 100%;
  padding: 6px;
  border-radius: 5px;
  border: 1px solid #ccc;
  font-size: 13px;
  margin-top: 2px;
}
.summary-grid {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 8px 12px;
}

@media (max-width: 768px) {
  .container { flex-direction: column; }
  .summary-grid { grid-template-columns: 1fr; }
}
</style>

<div class="container">
  <!-- Left side: purchase form -->
  <div class="form-section">
    <h2>New Purchase</h2>
    <form id="purchaseForm" onsubmit="return false;">
      <label>Product Name</label>
      <input type="text" id="product_name" required>

      <label>Price</label>
      <input type="number" id="price" required>

      <label>Quantity</label>
      <input type="number" id="qty" required>

      <label>Discount (Amount)</label>
      <input type="number" id="discount" value="0">

      <label>Total</label>
      <input type="number" id="total" readonly>

      <button type="button" class="add-btn" onclick="addToCart()">Add to Cart</button>
    </form>
  </div>

  <!-- Right side: cart -->
  <div class="cart-section">
    <h2>Cart Details</h2>
    <table id="cartTable">
      <thead>
        <tr>
          <th>Product</th>
          <th>Price</th>
          <th>Qty</th>
          <th>Discount</th>
          <th>Total</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody id="cartBody"></tbody>
      <tfoot>
        <tr>
          <td colspan="4" style="text-align:right;">Cart Total:</td>
          <td id="grandTotal">0</td>
          <td></td>
        </tr>
      </tfoot>
    </table>

    <div class="summary">
      <h3>Supplier & Payment</h3>
      <div class="summary-grid">
        <div>
          <label>Supplier</label>
          <select id="supplier" onchange="showSupplierBalance()">
            <option value="">Select</option>
            <?php while($row = $suppliers->fetch_assoc()): ?>
              <option value="<?php echo $row['id']; ?>" data-balance="<?php echo $row['balance']; ?>">
                <?php echo htmlspecialchars($row['supplier_name']); ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>

        <div>
          <label>Balance (৳)</label>
          <input type="number" id="supplierBalance" value="0" readonly>
        </div>

        <div>
          <label>Subtotal (৳)</label>
          <input type="number" id="subtotal" value="0" readonly>
        </div>

        <div>
          <label>Paid (৳)</label>
          <input type="number" id="paidAmount" value="0" oninput="calculateUnpaid()">
        </div>

        <div>
          <label>Unpaid (৳)</label>
          <input type="number" id="unpaidAmount" value="0" readonly>
        </div>

        <div>
          <label>Payment</label>
          <select id="paymentMethod">
            <option value="Cash">Cash</option>
            <option value="Card">Card</option>
          </select>
        </div>
      </div>
      <button type="button" class="purchase-btn" onclick="completePurchase()">Complete Purchase</button>
    </div>
  </div>
</div>

<script>
let cart = [];

function updateTotal() {
  const price = parseFloat(document.getElementById('price').value) || 0;
  const qty = parseInt(document.getElementById('qty').value) || 0;
  const discount = parseFloat(document.getElementById('discount').value) || 0;
  let total = (price * qty) - discount;
  if (total < 0) total = 0;
  document.getElementById('total').value = total.toFixed(2);
}
['price','qty','discount'].forEach(id => {
  document.getElementById(id).addEventListener('input', updateTotal);
});

function addToCart() {
  const product = document.getElementById('product_name').value.trim();
  const price = parseFloat(document.getElementById('price').value);
  const qty = parseInt(document.getElementById('qty').value);
  const discount = parseFloat(document.getElementById('discount').value);
  const total = parseFloat(document.getElementById('total').value);

  if (!product || price <= 0 || qty <= 0) {
    alert("Please fill all fields correctly.");
    return;
  }

  cart.push({ product, price, qty, discount, total });
  renderCart();
  document.getElementById('purchaseForm').reset();
  document.getElementById('total').value = '';
}

function renderCart() {
  const tbody = document.getElementById('cartBody');
  tbody.innerHTML = '';
  let grand = 0;

  cart.forEach((item, i) => {
    grand += item.total;
    tbody.innerHTML += `
      <tr>
        <td>${item.product}</td>
        <td>${item.price.toFixed(2)}</td>
        <td>${item.qty}</td>
        <td>${item.discount.toFixed(2)}</td>
        <td>${item.total.toFixed(2)}</td>
        <td><button style="background:#dc3545; color:white; border:none; border-radius:5px; padding:3px 6px;" onclick="removeItem(${i})">X</button></td>
      </tr>
    `;
  });

  document.getElementById('grandTotal').innerText = grand.toFixed(2);
  updateSubtotal();
}

function removeItem(index) {
  cart.splice(index, 1);
  renderCart();
}

function showSupplierBalance() {
  const supplierSelect = document.getElementById('supplier');
  const balance = parseFloat(supplierSelect.options[supplierSelect.selectedIndex].dataset.balance || 0);
  document.getElementById('supplierBalance').value = balance.toFixed(2);
  updateSubtotal();
}

function updateSubtotal() {
  const grand = parseFloat(document.getElementById('grandTotal').innerText) || 0;
  const balance = parseFloat(document.getElementById('supplierBalance').value) || 0;
  const subtotal = grand + balance;
  document.getElementById('subtotal').value = subtotal.toFixed(2);
  calculateUnpaid();
}

function calculateUnpaid() {
  const subtotal = parseFloat(document.getElementById('subtotal').value) || 0;
  const paid = parseFloat(document.getElementById('paidAmount').value) || 0;
  const unpaid = subtotal - paid;
  document.getElementById('unpaidAmount').value = unpaid.toFixed(2);
}



// function completePurchase() {
//   const supplier = document.getElementById('supplier').value;
//   const paymentMethod = document.getElementById('paymentMethod').value;
//   if (cart.length === 0) return alert("Cart is empty.");
//   if (!supplier) return alert("Please select a supplier.");

//   const subtotal = document.getElementById('subtotal').value;
//   const paid = document.getElementById('paidAmount').value;
//   const unpaid = document.getElementById('unpaidAmount').value;

//   alert(`✅ Purchase Complete!
// Supplier: ${supplier}
// Payment: ${paymentMethod}
// Subtotal: ৳${subtotal}
// Paid: ৳${paid}
// Unpaid: ৳${unpaid}`);

//   cart = [];
//   renderCart();
//   document.getElementById('supplier').value = '';
//   document.getElementById('supplierBalance').value = '0';
//   document.getElementById('subtotal').value = '0';
//   document.getElementById('paidAmount').value = '0';
//   document.getElementById('unpaidAmount').value = '0';
// }



async function completePurchase() {
  const supplier = document.getElementById('supplier').value;
  const paymentMethod = document.getElementById('paymentMethod').value;
  const subtotal = parseFloat(document.getElementById('subtotal').value) || 0;
  const paid = parseFloat(document.getElementById('paidAmount').value) || 0;
  const unpaid = parseFloat(document.getElementById('unpaidAmount').value) || 0;

  if (cart.length === 0) return alert("Cart is empty.");
  if (!supplier) return alert("Please select a supplier.");

  const response = await fetch('save_purchase.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({
      supplier_id: supplier,
      payment_method: paymentMethod,
      subtotal: subtotal,
      paid: paid,
      unpaid: unpaid,
      cart: cart
    })
  });

  const result = await response.json();

  if (result.success) {
    alert("✅ Purchase saved successfully!");
    cart = [];
    renderCart();
    document.getElementById('supplier').value = '';
    document.getElementById('supplierBalance').value = '0';
    document.getElementById('subtotal').value = '0';
    document.getElementById('paidAmount').value = '0';
    document.getElementById('unpaidAmount').value = '0';
  } else {
    alert("❌ Error: " + result.message);
  }
}

</script>
