<?php
session_start();
include "db.php";

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ✅ Fetch all purchase records with supplier info
$sql = "
SELECT p.id, p.supplier_id, s.supplier_name, s.mobile, s.address, s.balance,
       p.subtotal, p.paid, p.unpaid, p.payment_method, p.purchase_date
FROM purchases p
JOIN suppliers s ON p.supplier_id = s.id
ORDER BY p.id DESC";
$purchases = $conn->query($sql);
if (!$purchases) {
    die('SQL Error: ' . $conn->error);
}
?>

<style>
body, #mainContent {
  margin: 0 !important;
  padding: 0 !important;
  background: #f9f9f9;
  font-family: 'Segoe UI', Arial, sans-serif;
}

.container {
  margin: 20px;
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  padding: 20px;
}

h2 {
  border-bottom: 2px solid #007bff;
  padding-bottom: 5px;
  color: #333;
  margin-bottom: 15px;
}

.table-wrapper {
  overflow-x: auto;
}

table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 10px;
}

th, td {
  padding: 10px;
  border-bottom: 1px solid #eee;
  text-align: left;
  font-size: 15px;
}

th {
  background: #f4f4f4;
  color: #333;
}

tr:hover {
  background: #f1f9ff;
  cursor: pointer;
}

.details {
  display: none;
  background: #f9f9f9;
  border-left: 3px solid #007bff;
  padding: 10px 20px;
}

.details table {
  margin-top: 5px;
  background: #fff;
  width: 95%;
  border: 1px solid #ddd;
  border-radius: 6px;
}

.details th {
  background: #e9ecef;
  font-weight: bold;
}

.toggle-btn {
  background: #007bff;
  color: white;
  padding: 4px 10px;
  border-radius: 5px;
  cursor: pointer;
  border: none;
  font-size: 13px;
}

.toggle-btn:hover {
  background: #0056b3;
}

@media (max-width: 768px) {
  .container { margin: 10px; padding: 10px; }
  th, td { font-size: 13px; padding: 8px; }
}
</style>

<div class="container">
  <h2>📘 Purchase History</h2>
  <div class="table-wrapper">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Supplier</th>
          <th>Mobile</th>
          <th>Subtotal</th>
          <th>Paid</th>
          <th>Unpaid</th>
          <th>Payment</th>
          <th>Date</th>
          <th>Items</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($purchases->num_rows > 0): ?>
          <?php while ($row = $purchases->fetch_assoc()): ?>
            <tr>
              <td><?= $row['id']; ?></td>
              <td><?= htmlspecialchars($row['supplier_name']); ?></td>
              <td><?= htmlspecialchars($row['mobile']); ?></td>
              <td><?= number_format($row['subtotal'], 2); ?></td>
              <td><?= number_format($row['paid'], 2); ?></td>
              <td><?= number_format($row['unpaid'], 2); ?></td>
              <td><?= htmlspecialchars(ucfirst($row['payment_method'])); ?></td>
              <td><?= date('Y-m-d', strtotime($row['purchase_date'])); ?></td>
              <td><button class="toggle-btn" onclick="toggleDetails(<?= $row['id']; ?>)">View</button></td>
            </tr>

            <tr id="details-<?= $row['id']; ?>" class="details">
              <td colspan="9">
                <strong>Supplier Address:</strong> <?= htmlspecialchars($row['address']); ?><br>
                <strong>Supplier Balance:</strong> <?= number_format($row['balance'], 2); ?><br><br>

                <table>
                  <thead>
                    <tr>
                      <th>Product</th>
                      <th>Price</th>
                      <th>Qty (Type)</th>
                      <th>Discount</th>
                      <th>Total</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $items = $conn->query("SELECT * FROM purchase_items WHERE purchase_id = " . intval($row['id']));
                    if ($items && $items->num_rows > 0):
                      while ($it = $items->fetch_assoc()):
                    ?>
                    <tr>
                      <td><?= htmlspecialchars($it['product_name']); ?></td>
                      <td><?= number_format($it['price'], 2); ?></td>
                      <td><?= htmlspecialchars($it['qty']) . ' ' . htmlspecialchars($it['qty_type'] ?? 'pcs'); ?></td>
                      <td><?= number_format($it['discount'], 2); ?></td>
                      <td><?= number_format($it['total'], 2); ?></td>
                    </tr>
                    <?php endwhile; else: ?>
                    <tr><td colspan="5" style="text-align:center; color:#999;">No items found</td></tr>
                    <?php endif; ?>
                  </tbody>
                </table>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="9" style="text-align:center; color:#999;">No purchase records found</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
function toggleDetails(id) {
  const row = document.getElementById('details-' + id);
  row.style.display = (row.style.display === 'table-row') ? 'none' : 'table-row';
}
</script>
