<?php
session_start();
include "db.php";

if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$suppliers = $conn->query("SELECT id, supplier_name, balance FROM suppliers ORDER BY supplier_name ASC");
if (!$suppliers) {
  die("SQL Error: " . $conn->error);
}
?>

<style>
body, #mainContent {
  background: #f4f6f9;
  font-family: "Segoe UI", Arial, sans-serif;
  margin: 0;
  padding: 0;
}
.container {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  padding: 20px;
}
.form-section, .cart-section {
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  padding: 20px;
}
.form-section { flex: 1; min-width: 300px; }
.cart-section { flex: 2; min-width: 350px; }
h2 { color: #333; }
input, select {
  width: 100%;
  padding: 8px;
  margin-bottom: 10px;
  border: 1px solid #ccc;
  border-radius: 6px;
}
button {
  padding: 8px 12px;
  border: none;
  border-radius: 8px;
  color: white;
  cursor: pointer;
  font-weight: 600;
}
button:hover { transform: scale(1.05); }
.add-btn { background: #28a745; }
.purchase-btn { background: #007bff; width: 100%; margin-top: 10px; }
.product-btn { background: #6f42c1; margin-bottom: 10px; width: 100%; }

/* Modal styles */
.modal {
  display: none;
  position: fixed; z-index: 999; left: 0; top: 0;
  width: 100%; height: 100%; background: rgba(0,0,0,0.5);
  justify-content: center; align-items: center;
}
.modal-content {
  background: #fff; padding: 20px; border-radius: 10px; width: 300px;
  box-shadow: 0 3px 6px rgba(0,0,0,0.3);
}
.modal-content h3 { margin-bottom: 10px; color: #333; }
.close-btn {
  background: #dc3545; border: none; padding: 5px 10px; border-radius: 5px; color: #fff;
  float: right; cursor: pointer;
}
</style>

<div class="container">

  <!-- Left Form -->
  <div class="form-section">
    <h2>New Purchase</h2>
    <button type="button" class="product-btn" onclick="openProductModal()">➕ Add Purchase Product</button>

    <form id="purchaseForm" onsubmit="return false;">
      <label>Product Name</label>
      <select id="product_name" required>
        <option value="">Select Product</option>
        <?php
          $products = $conn->query("SELECT id, p_product_name FROM pu_product ORDER BY p_product_name ASC");
          if ($products && $products->num_rows > 0) {
              while ($row = $products->fetch_assoc()) {
                  echo '<option value="' . htmlspecialchars($row['p_product_name']) . '">' . htmlspecialchars($row['p_product_name']) . '</option>';
              }
          } else {
              echo '<option value="">No products found</option>';
          }
        ?>
      </select>

      <label>Price</label>
      <input type="number" id="price" required>

      <label>Quantity</label>
      <input type="number" id="qty" required>

      <label>Qty Type</label>
      <select id="qty_type" required>
        <option value="">Select Type</option>
        <option value="Pcs">Pcs</option>
        <option value="Packet">Packet</option>
        <option value="Kg">Kg</option>
      </select>

      <label>Discount (Amount)</label>
      <input type="number" id="discount" value="0">

      <label>Total</label>
      <input type="number" id="total" readonly>

      <button type="button" class="add-btn" onclick="addToCart()">Add to Cart</button>
    </form>
  </div>

  <!-- Right Section -->
  <div class="cart-section">
    <h2>Cart Details</h2>
    <table id="cartTable" style="width:100%; border-collapse: collapse;">
      <thead>
        <tr>
          <th>Product</th>
          <th>Price</th>
          <th>Qty</th>
          <th>Type</th>
          <th>Discount</th>
          <th>Total</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody id="cartBody"></tbody>
      <tfoot>
        <tr>
          <td colspan="5" style="text-align:right;">Cart Total:</td>
          <td id="grandTotal">0</td>
          <td></td>
        </tr>
      </tfoot>
    </table>

    <div class="summary">
      <h3>Supplier & Payment</h3>
      <div class="summary-grid">
        <div>
          <label>Supplier</label>
          <select id="supplier" onchange="showSupplierBalance()">
            <option value="">Select</option>
            <?php while($row = $suppliers->fetch_assoc()): ?>
              <option value="<?php echo $row['id']; ?>" data-balance="<?php echo $row['balance']; ?>">
                <?php echo htmlspecialchars($row['supplier_name']); ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>
        <div><label>Balance (৳)</label><input type="number" id="supplierBalance" value="0" readonly></div>
        <div><label>Subtotal (৳)</label><input type="number" id="subtotal" value="0" readonly></div>
        <div><label>Paid (৳)</label><input type="number" id="paidAmount" value="0" oninput="calculateUnpaid()"></div>
        <div><label>Unpaid (৳)</label><input type="number" id="unpaidAmount" value="0" readonly></div>
        <div><label>Payment</label><select id="paymentMethod"><option value="Cash">Cash</option><option value="Card">Card</option></select></div>
      </div>
      <button type="button" class="purchase-btn" onclick="completePurchase()">Complete Purchase</button>
    </div>
  </div>
</div>

<!-- Product Modal -->
<div id="productModal" class="modal">
  <div class="modal-content" style="width:600px; display:flex; gap:20px;">
    <div style="flex:1;">
      <button class="close-btn" onclick="closeProductModal()">X</button>
      <h3>Add Purchase Product</h3>
      <label>Product Name</label>
      <input type="text" id="newPurchaseProduct" placeholder="Enter product name">
      <button class="add-btn" onclick="savePurchaseProduct()">Save</button>
    </div>
    <div style="flex:1;">
      <h3>Existing Products</h3>
      <div style="max-height:300px; overflow-y:auto;">
        <table style="width:100%; border-collapse:collapse;" id="productListTable">
          <thead>
            <tr style="background:#f1f1f1;">
              <th>ID</th><th>Product Name</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
let cart = [];

function openProductModal() { document.getElementById('productModal').style.display = 'flex'; loadPurchaseProducts(); }
function closeProductModal() { document.getElementById('productModal').style.display = 'none'; }

async function savePurchaseProduct() {
  const name = document.getElementById('newPurchaseProduct').value.trim();
  if (!name) return alert("Please enter a product name.");

  const res = await fetch("save_purchase_product.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: "p_product_name=" + encodeURIComponent(name)
  });

  const data = await res.text();
  alert(data);
  document.getElementById('newPurchaseProduct').value = "";
  loadPurchaseProducts();
}

async function loadPurchaseProducts() {
  const res = await fetch("get_purchase_products.php");
  const html = await res.text();
  document.querySelector("#productListTable tbody").innerHTML = html;
}

// --- CART LOGIC ---
function updateTotal() {
  const price = parseFloat(document.getElementById('price').value) || 0;
  const qty = parseInt(document.getElementById('qty').value) || 0;
  const discount = parseFloat(document.getElementById('discount').value) || 0;
  let total = (price * qty) - discount;
  document.getElementById('total').value = total < 0 ? 0 : total.toFixed(2);
}
['price','qty','discount'].forEach(id => document.getElementById(id).addEventListener('input', updateTotal));

function addToCart() {
  const product = document.getElementById('product_name').value.trim();
  const price = parseFloat(document.getElementById('price').value);
  const qty = parseInt(document.getElementById('qty').value);
  const qty_type = document.getElementById('qty_type').value;
  const discount = parseFloat(document.getElementById('discount').value);
  const total = parseFloat(document.getElementById('total').value);
  if (!product || price <= 0 || qty <= 0 || !qty_type) return alert("Please fill all fields correctly.");

  cart.push({ product, price, qty, qty_type, discount, total });
  renderCart();
  document.getElementById('purchaseForm').reset();
  document.getElementById('total').value = '';
}

function renderCart() {
  const tbody = document.getElementById('cartBody');
  tbody.innerHTML = '';
  let grand = 0;
  cart.forEach((item, i) => {
    grand += item.total;
    tbody.innerHTML += `
      <tr>
        <td>${item.product}</td>
        <td>${item.price.toFixed(2)}</td>
        <td>${item.qty}</td>
        <td>${item.qty_type}</td>
        <td>${item.discount.toFixed(2)}</td>
        <td>${item.total.toFixed(2)}</td>
        <td><button style="background:#dc3545; padding:3px 6px; border:none; border-radius:5px;" onclick="removeItem(${i})">X</button></td>
      </tr>`;
  });
  document.getElementById('grandTotal').innerText = grand.toFixed(2);
  updateSubtotal();
}

function removeItem(index) { cart.splice(index, 1); renderCart(); }

function showSupplierBalance() {
  const supplierSelect = document.getElementById('supplier');
  const balance = parseFloat(supplierSelect.options[supplierSelect.selectedIndex].dataset.balance || 0);
  document.getElementById('supplierBalance').value = balance.toFixed(2);
  updateSubtotal();
}

function updateSubtotal() {
  const grand = parseFloat(document.getElementById('grandTotal').innerText) || 0;
  const balance = parseFloat(document.getElementById('supplierBalance').value) || 0;
  document.getElementById('subtotal').value = (grand + balance).toFixed(2);
  calculateUnpaid();
}

function calculateUnpaid() {
  const subtotal = parseFloat(document.getElementById('subtotal').value) || 0;
  const paid = parseFloat(document.getElementById('paidAmount').value) || 0;
  document.getElementById('unpaidAmount').value = (subtotal - paid).toFixed(2);
}

async function completePurchase() {
  const supplier = document.getElementById('supplier').value;
  const paymentMethod = document.getElementById('paymentMethod').value;
  const subtotal = parseFloat(document.getElementById('subtotal').value) || 0;
  const paid = parseFloat(document.getElementById('paidAmount').value) || 0;
  const unpaid = parseFloat(document.getElementById('unpaidAmount').value) || 0;

  if (cart.length === 0) return alert("Cart is empty.");
  if (!supplier) return alert("Please select a supplier.");

  try {
    const res = await fetch('save_purchase.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ supplier_id: supplier, payment_method: paymentMethod, subtotal, paid, unpaid, cart })
    });

    const result = await res.json();

    if (result.success) {
      alert("✅ Purchase saved successfully!");
      window.location.href = "dashboard.php";
    } else {
      alert("❌ Error: " + result.message);
    }
  } catch (err) {
    alert("❌ Network Error: " + err.message);
  }
}
</script>
