<?php
include "db.php";

// Detect action (GET or POST)
$action = $_GET['action'] ?? $_POST['action'] ?? '';

/* 🟢 Fetch all products */
if ($action === 'fetch') {
    $result = $conn->query("SELECT id, p_product_name, product_type, created_at FROM pu_product ORDER BY id DESC");
    $products = [];

    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }

    header('Content-Type: application/json');
    echo json_encode($products);
    exit;
}

/* 🟢 Add a new product */
if ($action === 'add') {
    $name = trim($_POST['p_product_name'] ?? '');
    $type = trim($_POST['product_type'] ?? '');

    if ($name === '' || $type === '') {
        echo "❌ Product name and type are required.";
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO pu_product (p_product_name, product_type, created_at) VALUES (?, ?, NOW())");
    $stmt->bind_param("ss", $name, $type);

    if ($stmt->execute()) {
        echo "✅ Product added successfully.";
    } else {
        echo "❌ Database error: " . $conn->error;
    }

    $stmt->close();
    exit;
}

/* 🟢 Update an existing product */
if ($action === 'update') {
    $id = intval($_POST['id'] ?? 0);
    $name = trim($_POST['p_product_name'] ?? '');
    $type = trim($_POST['product_type'] ?? '');

    if ($id <= 0 || $name === '' || $type === '') {
        echo "❌ Invalid product data.";
        exit;
    }

    $stmt = $conn->prepare("UPDATE pu_product SET p_product_name = ?, product_type = ? WHERE id = ?");
    $stmt->bind_param("ssi", $name, $type, $id);

    if ($stmt->execute()) {
        echo "✅ Product updated successfully.";
    } else {
        echo "❌ Database error: " . $conn->error;
    }

    $stmt->close();
    exit;
}

/* 🟢 Delete a product */
if ($action === 'delete') {
    $id = intval($_POST['id'] ?? 0);

    if ($id <= 0) {
        echo "❌ Invalid product ID.";
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM pu_product WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "✅ Product deleted successfully.";
    } else {
        echo "❌ Database error: " . $conn->error;
    }

    $stmt->close();
    exit;
}

/* 🔴 Invalid action fallback */
echo "❌ Invalid action requested.";
exit;
?>
