<?php
session_start();
include "db.php";

$startDate = $_GET['start'] ?? '';
$endDate   = $_GET['end'] ?? '';
$rows = [];

if ($startDate && $endDate) {
    // Fetch product sales report by menu order
$query = "
 SELECT 
    p.id AS product_id, 
    p.name AS product_name, 
    oi.price, 
    SUM(oi.qty) AS total_qty, 
    SUM(oi.total) AS total_amount
 FROM order_items oi
 INNER JOIN orders o ON oi.order_id = o.id
 INNER JOIN products p ON oi.product_name = p.name
 WHERE DATE(o.created_at) BETWEEN '$startDate' AND '$endDate'
 GROUP BY p.id, p.name, oi.price
 ORDER BY p.id ASC
";

    $res = $conn->query($query);
    if ($res) {
        while ($r = $res->fetch_assoc()) {
            $rows[] = $r;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>📊 Product Reports</title>
<style>
body {
    font-family: Arial, sans-serif;
    background: #f5f6fa;
    margin: 0;
    padding: 0;
}
.container {
    max-width: 1000px;
    margin: 30px auto;
    background: #fff;
    padding: 20px 30px;
    border-radius: 10px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
h2 {
    text-align: center;
    background: #007bff;
    color: #fff;
    margin: -20px -30px 20px -30px;
    padding: 15px;
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
}
.filters {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    flex-wrap: wrap;
}
.filters label {
    margin-right: 10px;
    font-weight: bold;
}
.filters input {
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 6px;
}
.filters button {
    background: #28a745;
    border: none;
    color: #fff;
    padding: 10px 18px;
    border-radius: 6px;
    cursor: pointer;
    font-weight: bold;
    transition: 0.2s;
}
.filters button:hover {
    background: #218838;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
}
th, td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: center;
}
th {
    background: #007bff;
    color: white;
}
tfoot td {
    font-weight: bold;
    background: #f1f1f1;
}
.no-data {
    text-align: center;
    padding: 20px;
    font-size: 16px;
    color: #666;
}
</style>
</head>
<body>
<div class="container">
    <h2>📊 Product Reports</h2>

    <form method="GET" class="filters">
        <div>
            <label>Start Date:</label>
            <input type="date" name="start" value="<?= htmlspecialchars($startDate) ?>" required>
            <label>End Date:</label>
            <input type="date" name="end" value="<?= htmlspecialchars($endDate) ?>" required>
        </div>
        <button type="submit">🔍 Find</button>
    </form>

    <?php if ($startDate && $endDate): ?>
        <?php if (!empty($rows)): ?>
            <table>
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Product Name</th>
                        <th>Price (৳)</th>
                        <th>Qty</th>
                        <th>Total (৳)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sl = 1;
                    $grandTotal = 0;
                    foreach ($rows as $r):
                        $grandTotal += $r['total_amount'];
                    ?>
                    <tr>
                        <td><?= $sl++ ?></td>
                        <td><?= htmlspecialchars($r['product_name']) ?></td>
                        <td><?= number_format($r['price'], 2) ?></td>
                        <td><?= htmlspecialchars($r['total_qty']) ?></td>
                        <td><?= number_format($r['total_amount'], 2) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="4">Grand Total</td>
                        <td>৳<?= number_format($grandTotal, 2) ?></td>
                    </tr>
                </tfoot>
            </table>
        <?php else: ?>
            <div class="no-data">No product sales found between these dates.</div>
        <?php endif; ?>
    <?php endif; ?>
</div>
</body>
</html>
