<?php
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Error: " . $conn->connect_error);

// Load categories for dropdown
if (isset($_GET['loadCategories'])) {
    $res = $conn->query("SELECT * FROM categories ORDER BY name ASC");
    while ($c = $res->fetch_assoc()) {
        echo "<option value='{$c['name']}'>{$c['name']}</option>";
    }
    exit;
}

// Load products table
if (isset($_GET['loadProducts'])) {
    $res = $conn->query("SELECT * FROM products ORDER BY id DESC");
    while ($r = $res->fetch_assoc()) {
        $img = $r['image'] ? "<img src='uploads/{$r['image']}' width='50'>" : "No Image";
        echo "<tr data-id='{$r['id']}' data-name='{$r['name']}' data-price='{$r['price']}' data-cat='{$r['category']}'>
                <td>{$r['id']}</td>
                <td>{$r['product_code']}</td>
                <td>{$r['name']}</td>
                <td>{$r['price']}</td>
                <td>{$r['category']}</td>
                <td>{$img}</td>
              </tr>";
    }
    exit;
}

// Handle POST actions
if ($_SERVER['REQUEST_METHOD'] === "POST") {
    $action = $_POST['action'] ?? '';
    $uploadDir = "uploads/";
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    $imageName = null;
    if (!empty($_FILES['image']['name'])) {
        $imageName = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir . $imageName);
    }

    // Add product
    if ($action === "add") {
        $stmt = $conn->prepare("INSERT INTO products (product_code, name, price, category, image) VALUES (?,?,?,?,?)");
        $code = uniqid("P");
        $stmt->bind_param("ssdss", $code, $_POST['name'], $_POST['price'], $_POST['category'], $imageName);
        echo $stmt->execute() ? "success" : "error: " . $stmt->error;
        exit;
    }

    // Update product
    if ($action === "update") {
        $id = $_POST['id'];
        if ($imageName) {
            $stmt = $conn->prepare("UPDATE products SET name=?, price=?, category=?, image=? WHERE id=?");
            $stmt->bind_param("sdssi", $_POST['name'], $_POST['price'], $_POST['category'], $imageName, $id);
        } else {
            $stmt = $conn->prepare("UPDATE products SET name=?, price=?, category=? WHERE id=?");
            $stmt->bind_param("sdsi", $_POST['name'], $_POST['price'], $_POST['category'], $id);
        }
        echo $stmt->execute() ? "updated" : "error: " . $stmt->error;
        exit;
    }

    // Delete product
    if ($action === "delete") {
        $id = $_POST['id'];
        $res = $conn->query("SELECT image FROM products WHERE id=$id");
        if ($row = $res->fetch_assoc()) {
            if ($row['image'] && file_exists($uploadDir . $row['image'])) unlink($uploadDir . $row['image']);
        }
        $stmt = $conn->prepare("DELETE FROM products WHERE id=?");
        $stmt->bind_param("i", $id);
        echo $stmt->execute() ? "deleted" : "error: " . $stmt->error;
        exit;
    }
}
?>

<!-- ✅ Inline CSS for Product Page -->
<style>
.form-container {
    background:#fff;
    padding:20px;
    border-radius:10px;
    box-shadow:0 2px 5px rgba(0,0,0,0.2);
    max-width:800px;
    margin:auto;
    font-family: Arial, sans-serif;
}
.form-container h2 {
    margin-bottom:15px;
    color:#2c3e50;
}
.form-container label {
    display:block;
    margin-top:10px;
    font-weight:bold;
}
.form-container input, 
.form-container select {
    width:100%;
    padding:8px;
    margin-top:5px;
    border:1px solid #ccc;
    border-radius:5px;
}
.form-container button {
    margin-top:15px;
    padding:10px 15px;
    border:none;
    border-radius:5px;
    cursor:pointer;
    font-size:14px;
}
#addBtn { background:#28a745; color:white; }
#updateBtn { background:#007bff; color:white; }
#deleteBtn { background:#dc3545; color:white; }
#message { margin-top:10px; font-weight:bold; }
#productTable { margin-top:20px; border-collapse:collapse; width:100%; }
#productTable th, #productTable td { border:1px solid #ccc; padding:8px; text-align:left; }
#productTable th { background:#2c3e50; color:#fff; }
#productTable tr:hover { background:#f1f1f1; cursor:pointer; }
</style>

<div class="form-container">
    <h2>Manage Product</h2>
    <form id="productForm" enctype="multipart/form-data">
        <input type="hidden" name="id" id="productId">
        <label>Name</label>
        <input type="text" name="name" id="productName" required>

        <label>Price</label>
        <input type="number" step="0.01" name="price" id="productPrice" required>

        <label>Category</label>
        <select name="category" id="productCategory" required>
            <option value="">--Select--</option>
            <?php
            $res = $conn->query("SELECT * FROM categories ORDER BY name ASC");
            while ($c = $res->fetch_assoc()) {
                echo "<option value='{$c['name']}'>{$c['name']}</option>";
            }
            ?>
        </select>

        <label>Image</label>
        <input type="file" name="image" id="productImage" accept="image/*">

        <button type="button" id="addBtn">Add Product</button>
        <button type="button" id="updateBtn" style="display:none;">Update</button>
        <button type="button" id="deleteBtn" style="display:none;">Delete</button>
    </form>
    <p id="message"></p>

    <h2>Product List</h2>
    <table id="productTable">
        <thead>
            <tr>
                <th>ID</th><th>Code</th><th>Name</th><th>Price</th><th>Category</th><th>Image</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
function attachProductFormHandler() {
    const form = document.getElementById("productForm");
    const addBtn = document.getElementById("addBtn");
    const updateBtn = document.getElementById("updateBtn");
    const deleteBtn = document.getElementById("deleteBtn");
    const message = document.getElementById("message");
    const table = document.getElementById("productTable").getElementsByTagName("tbody")[0];

    function loadProducts() {
        fetch("product_add.php?loadProducts=1")
            .then(res => res.text())
            .then(data => table.innerHTML = data);
    }

    loadProducts();

    addBtn.onclick = () => {
        const fd = new FormData(form);
        fd.append("action", "add");
        fetch("product_add.php", { method: "POST", body: fd })
            .then(res => res.text())
            .then(d => {
                message.innerText = d.includes("success") ? "✅ Product added!" : "❌ " + d;
                loadProducts();
                form.reset();
                updateBtn.style.display = "none";
                deleteBtn.style.display = "none";
                addBtn.style.display = "inline-block";
            });
    };

    updateBtn.onclick = () => {
        const fd = new FormData(form);
        fd.append("action", "update");
        fetch("product_add.php", { method: "POST", body: fd })
            .then(res => res.text())
            .then(d => {
                message.innerText = d.includes("updated") ? "✅ Updated!" : "❌ " + d;
                loadProducts();
                form.reset();
                updateBtn.style.display = "none";
                deleteBtn.style.display = "none";
                addBtn.style.display = "inline-block";
            });
    };

    deleteBtn.onclick = () => {
        if (!confirm("Are you sure to delete?")) return;
        const fd = new FormData(form);
        fd.append("action", "delete");
        fetch("product_add.php", { method: "POST", body: fd })
            .then(res => res.text())
            .then(d => {
                message.innerText = d.includes("deleted") ? "🗑️ Deleted!" : "❌ " + d;
                loadProducts();
                form.reset();
                updateBtn.style.display = "none";
                deleteBtn.style.display = "none";
                addBtn.style.display = "inline-block";
            });
    };

    // Click table row to edit
    table.addEventListener("click", e => {
        const tr = e.target.closest("tr");
        if (!tr) return;
        form.reset();
        document.getElementById("productId").value = tr.dataset.id;
        document.getElementById("productName").value = tr.dataset.name;
        document.getElementById("productPrice").value = tr.dataset.price;
        document.getElementById("productCategory").value = tr.dataset.cat;
        addBtn.style.display = "none";
        updateBtn.style.display = "inline-block";
        deleteBtn.style.display = "inline-block";
    });
}

// Run immediately if page loaded directly
attachProductFormHandler();
</script>
