<?php
// ============================
// Q Bistro - Remaining Items Receipt (Auto Print + Auto Cut)
// ============================

require __DIR__ . '/vendor/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\CapabilityProfile;

// ✅ Connect to database
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) { die("DB connection failed"); }

// ✅ Get Rest Order ID
$restOrderId = intval($_GET['id'] ?? 0);
if ($restOrderId <= 0) {
    die("❌ Invalid rest order ID");
}

// ✅ Fetch main rest order
$orderRes = $conn->query("SELECT * FROM rest_orders WHERE id = $restOrderId LIMIT 1");
$order = $orderRes->fetch_assoc();
if (!$order) { die("❌ Rest order not found"); }

// ✅ Fetch rest order items
$items = $conn->query("SELECT * FROM rest_order_items WHERE rest_order_id = $restOrderId");

// ============================
// Build ESC/POS Receipt
// ============================
ob_start();

$profile = CapabilityProfile::load("simple");
$connector = new FilePrintConnector("php://output");
$printer = new Printer($connector, $profile);

// ===== Header =====
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->setTextSize(2, 1);
$printer->text("Remaining Items\n");
$printer->setTextSize(1, 1);
$printer->text("Q Bistro\n");
$printer->text("Lucky Market, Beanibazar\n");
$printer->text("Mob: 01341862571\n");
$printer->text(str_repeat("-", 32) . "\n");

// ===== Info =====
$printer->setJustification(Printer::JUSTIFY_LEFT);
$printer->text("Date: " . date("d-m-Y H:i", strtotime($order['created_at'])) . "\n");
$printer->text(str_repeat("-", 32) . "\n");

// ===== Items =====
while ($row = $items->fetch_assoc()) {
    $name = substr($row['product_name'], 0, 18);
    $qty  = "x" . $row['qty'];
    $price = "" . number_format($row['total'], 2);
    $line = str_pad($name . " " . $qty, 22) . str_pad($price, 10, ' ', STR_PAD_LEFT);
    $printer->text($line . "\n");
}

$printer->text(str_repeat("-", 32) . "\n");

// ===== Totals =====
$printer->setJustification(Printer::JUSTIFY_RIGHT);
$printer->text("Total Items: " . $order['total_items'] . "\n");
$printer->text("Total Value: " . number_format($order['total_amount'], 2) . "\n");

// ===== Footer =====
$printer->feed(2);
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->text("Thank you!\n");

// ===== Auto Cut =====
$printer->cut();
$printer->close();

// Capture binary ESC/POS data
$output = ob_get_clean();

// Encode binary data for RawBT intent URL
$encodedData = urlencode($output);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Printing Rest Items...</title>
<script>
window.onload = function() {
    // Send ESC/POS data to RawBT app
    const escposData = "<?php echo $encodedData; ?>";
    const rawbtUrl =
        "intent://print?raw=" + escposData +
        "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end";

    // Open RawBT automatically
    window.location.href = rawbtUrl;

    // Redirect to dashboard after printing
    setTimeout(() => {
        window.location.href = "dashboard.php";
    }, 5000);
};
</script>
<style>
body {
  font-family: monospace;
  text-align: center;
  padding: 60px;
  background: #fff;
}
h3 {
  color: #222;
}
</style>
</head>
<body>
  <h3>🖨️ Printing Remaining Items Receipt...</h3>
  <p>If printing doesn’t start, open with RawBT app.</p>
</body>
</html>
