<?php
require __DIR__ . '/vendor/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\CapabilityProfile;

include "db.php";
$source = $_GET['source'] ?? '';
if ($source == '') die("❌ No source provided.");

$res = $conn->query("SELECT * FROM orderpad_order_productlist WHERE source='$source'");
if ($res->num_rows == 0) die("❌ No items found.");

ob_start();
$profile = CapabilityProfile::load("simple");
$connector = new FilePrintConnector("php://output");
$printer = new Printer($connector, $profile);

$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->setTextSize(2, 2);
$printer->text("Q Bistro\n");
$printer->setTextSize(1, 1);
$printer->text("OrderPad - $source\n");
$printer->text(str_repeat("-", 32) . "\n");

$printer->setJustification(Printer::JUSTIFY_LEFT);
while ($row = $res->fetch_assoc()) {
  $printer->text($row['product_name'] . "\n");
  $printer->text("  Qty: " . $row['qty'] . "\n");
  $printer->text(str_repeat("-", 32) . "\n");
}

$printer->feed(2);
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->text("End of $source List\n");
$printer->cut();
$printer->close();

$output = ob_get_clean();
$encoded = urlencode($output);
?>
<!DOCTYPE html>
<html>
<head><meta charset="UTF-8"><title>Printing...</title>
<script>
window.onload = function() {
  const data = "<?php echo $encoded; ?>";
  const url = "intent://print?raw=" + data + "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end";
  window.location.href = url;
  setTimeout(()=>window.location.href="order_pad.php", 4000);
};
</script>
</head>
<body style="text-align:center;padding:50px;font-family:monospace;">
<h3>🖨️ Printing <?= htmlspecialchars($source) ?> List...</h3>
<p>If it doesn’t print automatically, open with RawBT.</p>
</body>
</html>
