<?php
// ============================
// Q Bistro - Daily Report Auto Print + Auto Cut
// ============================

require __DIR__ . '/vendor/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\CapabilityProfile;

// ✅ Database connection
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("❌ Database Connection Failed: " . $conn->connect_error);
}

// ✅ Get current date and day
$date = date('Y-m-d');
$day  = date('l');

// ✅ Initialize totals
$total_sales = 0;
$total_purchases = 0;
$total_staff_cost = 0;

// ✅ Sales total
$res = $conn->query("SELECT SUM(final_total) AS total FROM orders WHERE DATE(created_at) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_sales = $row['total'] ?? 0;

// ✅ Purchases total
$res = $conn->query("SELECT SUM(subtotal) AS total FROM purchases WHERE DATE(purchase_date) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_purchases = $row['total'] ?? 0;

// ✅ Staff payments
$res = $conn->query("SELECT SUM(amount) AS total FROM staff_payments WHERE DATE(payment_date) = '$date'");
if ($res && $row = $res->fetch_assoc()) $total_staff_cost = $row['total'] ?? 0;

$conn->close();

// ✅ Calculate net profit/loss
$net = $total_sales - ($total_purchases + $total_staff_cost);

// ============================
// Build ESC/POS binary data
// ============================
ob_start();
$profile = CapabilityProfile::load("simple");
$connector = new FilePrintConnector("php://output");
$printer = new Printer($connector, $profile);

// ===== Header =====
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->setTextSize(2, 1);
$printer->text("Q Bistro\n");
$printer->setTextSize(1, 1);
$printer->text("Lucky Market, Beanibazar\n");
$printer->text("Mob: 01341862571\n");
$printer->text(str_repeat("-", 32) . "\n");

// ===== Title =====
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->text("📅 DAILY REPORT\n");
$printer->text("Date: " . date("d-m-Y") . " ($day)\n");
$printer->text(str_repeat("-", 32) . "\n");

// ===== Body =====
$printer->setJustification(Printer::JUSTIFY_LEFT);
$printer->text(str_pad("Total Sales:", 20) . str_pad("" . number_format($total_sales, 2), 12, ' ', STR_PAD_LEFT) . "\n");
$printer->text(str_pad("Total Purchase:", 20) . str_pad("" . number_format($total_purchases, 2), 12, ' ', STR_PAD_LEFT) . "\n");
$printer->text(str_pad("Staff Cost:", 20) . str_pad("" . number_format($total_staff_cost, 2), 12, ' ', STR_PAD_LEFT) . "\n");
$printer->text(str_repeat("-", 32) . "\n");

// ===== Net Result =====
if ($net >= 0) {
    $printer->setEmphasis(true);
    $printer->text(str_pad("Net Profit:", 20) . str_pad("" . number_format($net, 2), 12, ' ', STR_PAD_LEFT) . "\n");
    $printer->setEmphasis(false);
} else {
    $printer->setEmphasis(true);
    $printer->text(str_pad("Net Loss:", 20) . str_pad("-" . number_format(abs($net), 2), 12, ' ', STR_PAD_LEFT) . "\n");
    $printer->setEmphasis(false);
}

$printer->text(str_repeat("-", 32) . "\n");

// ===== Footer =====
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->feed(2);
$printer->text("Thank you for choosing Q Bistro!\n");
$printer->text("Visit again 🍴\n");

// ===== Auto Cut =====
$printer->cut();
$printer->close();

// Capture binary ESC/POS output
$output = ob_get_clean();
$encodedData = urlencode($output);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Printing Daily Report...</title>
<script>
window.onload = function() {
    const escposData = "<?php echo $encodedData; ?>";
    const rawbtUrl =
        "intent://print?raw=" + escposData +
        "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end";

    // Auto-open RawBT app for printing
    window.location.href = rawbtUrl;

    // Redirect to dashboard after print
    setTimeout(() => {
        window.location.href = "dashboard.php";
    }, 5000);
};
</script>
<style>
body {
  font-family: monospace;
  text-align: center;
  padding: 60px;
}
h3 {
  color: #111;
}
</style>
</head>
<body>
  <h3>🖨️ Printing Daily Report...</h3>
  <p>If printing doesn’t start automatically, open in RawBT app.</p>
</body>
</html>
