<?php
// ============================
// Q Bistro Collection Receipt (Auto Print ×2)
// Optimized for 58mm thermal printer
// ============================

require __DIR__ . '/vendor/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\CapabilityProfile;

// Database connection
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) { die("DB connection failed"); }

// Get order ID
$orderId = intval($_GET['id'] ?? 0);
if ($orderId <= 0) { die("❌ Invalid order ID"); }

// ✅ Fetch order
$orderRes = $conn->query("SELECT * FROM orders WHERE id = $orderId AND order_type='collection' LIMIT 1");
$order = $orderRes->fetch_assoc();
if (!$order) { die("❌ Order not found"); }

// ✅ Fetch order items
$itemRes = $conn->query("SELECT * FROM order_items WHERE order_id = $orderId");
$items = $itemRes->fetch_all(MYSQLI_ASSOC);

// Function to print one copy
function build_receipt($order, $items, $copyLabel) {
    $profile = CapabilityProfile::load("simple");
    $connector = new FilePrintConnector("php://output");
    $printer = new Printer($connector, $profile);

    // ===== Header =====
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setTextSize(2, 2);
    $printer->setEmphasis(true);
    $printer->text("Q Bistro\n");
    $printer->setEmphasis(false);
    $printer->setTextSize(1, 1);
    $printer->text("Lucky Market, Beanibazar\n");
    $printer->text("Mob: 01341862571\n");
    $printer->text(str_repeat("-", 32) . "\n");

    // ===== Order Info =====
    $printer->setJustification(Printer::JUSTIFY_LEFT);
    $printer->setEmphasis(true);
    $printer->text("Order No: " . $order['id'] . "\n");
    $printer->setEmphasis(false);

    // 🔥 Big bold type “COLLECTION”
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setTextSize(2, 2);
    $printer->setEmphasis(true);
    $printer->text("COLLECTION\n");
    $printer->setEmphasis(false);
    $printer->setTextSize(1, 1);
    $printer->setJustification(Printer::JUSTIFY_LEFT);

    if (!empty($order['customer_name'])) $printer->text("Customer: " . $order['customer_name'] . "\n");
    if (!empty($order['customer_phone'])) $printer->text("Phone: " . $order['customer_phone'] . "\n");
    $printer->text("Payment: " . ucfirst($order['payment_type']) . "\n");
    $printer->text("Date: " . date("d-m-Y H:i", strtotime($order['created_at'])) . "\n");
    $printer->text(str_repeat("-", 32) . "\n");

    // ===== Items =====
    foreach ($items as $row) {
        $name = substr($row['product_name'], 0, 18);
        $qty = "x" . $row['qty'];
        $price = number_format($row['total'], 2);
        $printer->setTextSize(1, 1);
        $printer->setEmphasis(true);
        $printer->text($name . "\n");
        $printer->setEmphasis(false);
        $printer->text("   " . str_pad($qty, 6) . str_pad($price, 20, ' ', STR_PAD_LEFT) . "\n");
    }

    $printer->text(str_repeat("-", 32) . "\n");

    // ===== Totals =====
    $printer->setJustification(Printer::JUSTIFY_RIGHT);
    $printer->setTextSize(1, 1);
    $printer->text("Subtotal: " . number_format($order['subtotal'], 2) . "\n");
    if ($order['discount'] > 0) $printer->text("Discount: -" . number_format($order['discount'], 2) . "\n");
    if ($order['tip'] > 0) $printer->text("Tip: " . number_format($order['tip'], 2) . "\n");

    $printer->setTextSize(2, 2);
    $printer->setEmphasis(true);
    $printer->text("TOTAL: " . number_format($order['final_total'], 2) . "\n");
    $printer->setEmphasis(false);
    $printer->setTextSize(1, 1);
    $printer->text(str_repeat("-", 32) . "\n");

    // ===== Copy Label =====
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setTextSize(1, 1);
    $printer->setEmphasis(true);
    $printer->text("*** " . strtoupper($copyLabel) . " COPY ***\n");
    $printer->setEmphasis(false);
    $printer->feed(2);

    // ===== Footer =====
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setTextSize(1, 1);
    $printer->text("Thank you! Visit again\n");
    $printer->text(str_repeat("-", 32) . "\n");

    // ===== Cut =====
    $printer->cut();
    $printer->close();
}

// Start output capture
ob_start();

// Print two copies — Shop & Customer
build_receipt($order, $items, "Shop");
build_receipt($order, $items, "Customer");

$output = ob_get_clean();
$conn->close();

// Encode binary data for RawBT
$encodedData = urlencode($output);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Printing 2 Copies...</title>
<script>
window.onload = function() {
  const escposData = "<?php echo $encodedData; ?>";
  const rawbtUrl = "intent://print?raw=" + escposData + "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end";
  window.location.href = rawbtUrl;

  // redirect after 5 seconds
  setTimeout(() => {
    window.location.href = "dashboard.php";
  }, 5000);
};
</script>
<style>
body {
  font-family: monospace;
  text-align: center;
  padding: 50px;
  background: #fff;
  max-width: 58mm;
  margin: auto;
}
h3 { color: #222; font-size: 18px; }
p { font-size: 14px; }
</style>
</head>
<body>
<h3>🖨️ Printing 2 Receipts (Shop + Customer)...</h3>
<p>If it doesn’t auto-print, open with RawBT manually.</p>
</body>
</html>
