<?php
session_start();
include "db.php";

// Set proper JSON header
header('Content-Type: application/json; charset=utf-8');

// 🛑 Validate order_id
if (!isset($_GET['order_id']) || !is_numeric($_GET['order_id'])) {
    echo json_encode([
        "status" => "error",
        "message" => "No valid order ID provided."
    ]);
    exit;
}

$order_id = intval($_GET['order_id']);

// ==========================
// 🔹 Fetch Order Details
// ==========================
$order_sql = "SELECT * FROM orders WHERE id = $order_id LIMIT 1";
$order_res = $conn->query($order_sql);

if (!$order_res || $order_res->num_rows === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Order not found."
    ]);
    exit;
}

$order = $order_res->fetch_assoc();

// ==========================
// 🔹 Fetch Order Items
// ==========================
$item_sql = "SELECT product_id, product_name, price, qty FROM order_items WHERE order_id = $order_id";
$item_res = $conn->query($item_sql);

$items = [];
if ($item_res && $item_res->num_rows > 0) {
    while ($row = $item_res->fetch_assoc()) {
        $items[] = [
            "product_id"   => (int)$row['product_id'],
            "product_name" => $row['product_name'],
            "price"        => (float)$row['price'],
            "qty"          => (int)$row['qty']
        ];
    }
}

// ==========================
// 🔹 Store in Session
// ==========================
$_SESSION['edit_order'] = [
    'order_id'       => $order['id'],
    'customer_name'  => $order['customer_name'],
    'customer_phone' => $order['customer_phone'],
    'order_type'     => $order['order_type'],
    'payment_type'   => $order['payment_type'],
    'items'          => $items
];

// ==========================
// 🔹 Return JSON to Browser
// ==========================
echo json_encode([
    "status"  => "success",
    "message" => "Order data prepared successfully.",
    "order"   => [
        "id"             => (int)$order['id'],
        "customer_name"  => $order['customer_name'],
        "customer_phone" => $order['customer_phone'],
        "order_type"     => $order['order_type'],
        "payment_type"   => $order['payment_type'],
        "items"          => $items
    ]
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

exit;
?>
