<?php
header('Content-Type: application/json; charset=utf-8');
include "db.php";

// Connect
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    echo json_encode(["status"=>"error","message"=>"DB connect error: ".$conn->connect_error]);
    exit;
}

// Read POST values (FormData)
$supplier_id = intval($_POST['supplier_id'] ?? 0);
$mobile      = trim($_POST['mobile'] ?? '');
$old_balance = floatval($_POST['balance'] ?? 0);
$pay_amount  = floatval($_POST['pay_amount'] ?? 0);
$new_balance = floatval($_POST['new_balance'] ?? 0);
$payment_type= trim($_POST['payment_type'] ?? 'Cash');
$notes       = trim($_POST['notes'] ?? '');

if ($supplier_id <= 0) {
    echo json_encode(["status"=>"error","message"=>"Invalid supplier"]);
    exit;
}
if ($pay_amount <= 0) {
    echo json_encode(["status"=>"error","message"=>"Payment amount must be greater than 0"]);
    exit;
}

// Ensure payments table exists (safe CREATE TABLE IF NOT EXISTS)
$createSql = "CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    supplier_id INT NOT NULL,
    supplier_name VARCHAR(150) DEFAULT '',
    mobile VARCHAR(50) DEFAULT '',
    old_balance DECIMAL(12,2) DEFAULT 0,
    pay_amount DECIMAL(12,2) DEFAULT 0,
    new_balance DECIMAL(12,2) DEFAULT 0,
    payment_type VARCHAR(30) DEFAULT '',
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
if (!$conn->query($createSql)) {
    echo json_encode(["status"=>"error","message"=>"Failed to create payments table: ".$conn->error]);
    exit;
}

// Get supplier name (exists?)
$sel = $conn->prepare("SELECT supplier_name FROM suppliers WHERE id = ?");
if (!$sel) {
    echo json_encode(["status"=>"error","message"=>"Prepare failed (select supplier): ".$conn->error]);
    exit;
}
$sel->bind_param("i", $supplier_id);
if (!$sel->execute()) {
    echo json_encode(["status"=>"error","message"=>"Execute failed (select supplier): ".$sel->error]);
    exit;
}
$res = $sel->get_result();
if (!$res || $res->num_rows === 0) {
    echo json_encode(["status"=>"error","message"=>"Supplier not found"]);
    exit;
}
$row = $res->fetch_assoc();
$supplier_name = $row['supplier_name'];
$sel->close();

// Insert payment record
$insertSql = "INSERT INTO payments 
    (supplier_id, supplier_name, mobile, old_balance, pay_amount, new_balance, payment_type, notes)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($insertSql);
if (!$stmt) {
    echo json_encode(["status"=>"error","message"=>"Prepare failed (insert payment): ".$conn->error]);
    exit;
}

// types: i s s d d d s s  -> "issdddss"
$stmt->bind_param(
    "issdddss",
    $supplier_id,
    $supplier_name,
    $mobile,
    $old_balance,
    $pay_amount,
    $new_balance,
    $payment_type,
    $notes
);

if (!$stmt->execute()) {
    echo json_encode(["status"=>"error","message"=>"Execute failed (insert payment): ".$stmt->error]);
    $stmt->close();
    exit;
}
$stmt->close();

// Update supplier balance
$up = $conn->prepare("UPDATE suppliers SET balance = ? WHERE id = ?");
if (!$up) {
    echo json_encode(["status"=>"error","message"=>"Prepare failed (update supplier): ".$conn->error]);
    exit;
}
$up->bind_param("di", $new_balance, $supplier_id);
if (!$up->execute()) {
    echo json_encode(["status"=>"error","message"=>"Execute failed (update supplier): ".$up->error]);
    $up->close();
    exit;
}
$up->close();

echo json_encode(["status"=>"success","message"=>"Payment saved and supplier balance updated"]);
$conn->close();
