<?php
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Connection Error: " . $conn->connect_error);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Supplier Payment</title>
<style>
body {
  margin: 0;
  font-family: "Poppins", Arial, sans-serif;
  background: #f5f7fa;
}
.payment-page {
  display: flex;
  gap: 20px;
  padding: 20px;
  min-height: 100vh;
}

/* Left Form */
.payment-form {
  flex: 1;
  background: #fff;
  padding: 25px;
  border-radius: 12px;
  box-shadow: 0 3px 8px rgba(0,0,0,0.08);
  display: flex;
  flex-direction: column;
  gap: 16px;
}
.payment-form h2 {
  color: #007bff;
  font-size: 22px;
  margin-bottom: 10px;
  border-bottom: 2px solid #007bff;
  padding-bottom: 6px;
}
.form-group {
  display: flex;
  flex-direction: column;
  gap: 5px;
}
.form-group label {
  font-weight: 600;
  color: #333;
  font-size: 14px;
}
.form-group select, .form-group input, .form-group textarea {
  padding: 10px 12px;
  border: 1px solid #ccc;
  border-radius: 6px;
  font-size: 14px;
  transition: border 0.2s, box-shadow 0.2s;
}
.form-group select:focus, .form-group input:focus, .form-group textarea:focus {
  border-color: #007bff;
  box-shadow: 0 0 0 3px rgba(0,123,255,0.1);
  outline: none;
}
.payment-form button {
  padding: 12px;
  background: #007bff;
  border: none;
  color: #fff;
  font-weight: 600;
  font-size: 15px;
  border-radius: 6px;
  cursor: pointer;
  transition: 0.2s;
}
.payment-form button:hover {
  background: #0056b3;
}

/* Notification Banner */
.alert {
  padding: 10px;
  border-radius: 6px;
  font-weight: 600;
  text-align: center;
  display: none;
}
.alert.success {
  background: #d4edda;
  color: #155724;
}
.alert.error {
  background: #f8d7da;
  color: #721c24;
}

/* Right Table */
.payment-list {
  flex: 2;
  background: #fff;
  padding: 25px;
  border-radius: 12px;
  box-shadow: 0 3px 8px rgba(0,0,0,0.08);
  overflow-y: auto;
}
.payment-list h2 {
  color: #007bff;
  font-size: 22px;
  border-bottom: 2px solid #007bff;
  padding-bottom: 6px;
  margin-bottom: 15px;
}
table {
  width: 100%;
  border-collapse: collapse;
  font-size: 14px;
}
th, td {
  border: 1px solid #eee;
  padding: 8px 10px;
  text-align: left;
}
th {
  background-color: #eef7ff;
  color: #007bff;
}
tr:nth-child(even) {
  background-color: #f9f9f9;
}

/* Responsive */
@media (max-width: 900px) {
  .payment-page {
    flex-direction: column;
  }
  .payment-form, .payment-list {
    width: 100%;
  }
}
</style>
</head>
<body>

<div class="payment-page">
  <!-- LEFT FORM -->
  <div class="payment-form">
    <h2>Make Supplier Payment</h2>

    <div id="alertBox" class="alert"></div>

    <form id="paymentForm">
      <div class="form-group">
        <label>Supplier Name</label>
        <select name="supplier_id" id="supplierSelect" required>
          <option value="">Select Supplier</option>
          <?php
          $res = $conn->query("SELECT id, supplier_name FROM suppliers ORDER BY supplier_name ASC");
          while($row = $res->fetch_assoc()) {
              echo "<option value='{$row['id']}'>{$row['supplier_name']}</option>";
          }
          ?>
        </select>
      </div>

      <div class="form-group">
        <label>Mobile Number</label>
        <input type="text" id="mobile" name="mobile" readonly>
      </div>

      <div class="form-group">
        <label>Current Balance (৳)</label>
        <input type="number" id="balance" name="balance" readonly>
      </div>

      <div class="form-group">
        <label>Pay Amount (৳)</label>
        <input type="number" step="0.01" id="pay_amount" name="pay_amount" required>
      </div>

      <div class="form-group">
        <label>New Balance (৳)</label>
        <input type="number" id="new_balance" name="new_balance" readonly>
      </div>

      <div class="form-group">
        <label>Payment Type</label>
        <select name="payment_type" required>
          <option value="Cash">Cash</option>
          <option value="Card">Card</option>
        </select>
      </div>

      <div class="form-group">
        <label>Notes</label>
        <textarea name="notes" rows="3" placeholder="Optional..."></textarea>
      </div>

      <button type="submit">💳 Submit Payment</button>
    </form>
  </div>

  <!-- RIGHT TABLE -->
  <div class="payment-list">
    <h2>Payment History</h2>
    <table id="paymentTable">
      <thead>
        <tr>
          <th>#</th>
          <th>Supplier</th>
          <th>Old (৳)</th>
          <th>Paid (৳)</th>
          <th>New (৳)</th>
          <th>Type</th>
          <th>Date</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
// Fetch supplier info
document.getElementById("supplierSelect").addEventListener("change", function() {
  const supplierId = this.value;
  if (!supplierId) return;
  fetch(`supplier_info.php?id=${supplierId}`)
    .then(res => res.json())
    .then(data => {
      document.getElementById("mobile").value = data.mobile || '';
      document.getElementById("balance").value = data.balance || 0;
      document.getElementById("new_balance").value = data.balance || 0;
    });
});

// Auto calculate new balance
document.getElementById("pay_amount").addEventListener("input", function() {
  const balance = parseFloat(document.getElementById("balance").value) || 0;
  const pay = parseFloat(this.value) || 0;
  document.getElementById("new_balance").value = (balance - pay).toFixed(2);
});

// Load payments table
function loadPayments() {
  fetch("payment_fetch.php")
    .then(res => res.text())
    .then(html => document.querySelector("#paymentTable tbody").innerHTML = html);
}

// Submit form
document.getElementById("paymentForm").addEventListener("submit", function(e){
  e.preventDefault();
  const btn = this.querySelector("button");
  const alertBox = document.getElementById("alertBox");

  btn.disabled = true;
  btn.textContent = "Processing...";

  const formData = new FormData(this);
  fetch("payment_add.php", { method:"POST", body: formData })
    .then(res => res.json())
    .then(data => {
      alertBox.style.display = "block";
      if (data.status === "success") {
        alertBox.textContent = "✅ " + data.message;
        alertBox.className = "alert success";
        this.reset();
        document.getElementById("mobile").value = '';
        document.getElementById("balance").value = '';
        document.getElementById("new_balance").value = '';
        loadPayments();
      } else {
        alertBox.textContent = "❌ " + data.message;
        alertBox.className = "alert error";
      }
      setTimeout(() => alertBox.style.display = "none", 4000);
    })
    .catch(err => {
      alertBox.style.display = "block";
      alertBox.textContent = "⚠️ Request failed: " + err;
      alertBox.className = "alert error";
    })
    .finally(() => {
      btn.disabled = false;
      btn.textContent = "💳 Submit Payment";
    });
});

loadPayments();
</script>
</body>
</html>
