<?php
// ✅ Database Connection
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Connection Error: " . $conn->connect_error);

$table = intval($_GET['table'] ?? 0);
$type = $_GET['type'] ?? 'dinein';

// ✅ Check if table is booked or available
$table_status = "available";
if ($type === "dinein" && $table > 0) {
    $resStatus = $conn->query("SELECT status FROM dine_in_tables WHERE id=$table");
    if ($resStatus && $rowStatus = $resStatus->fetch_assoc()) {
        $table_status = $rowStatus['status'];
    }
}
?>
<div class="order-page">
  <div class="order-container">

    <!-- ✅ Product Section -->
    <div class="products-list">
      <h2><?php echo ($type === 'dinein') ? "Order for Table {$table}" : ucfirst($type) . " Order"; ?></h2>
      <div class="products-container">
        <?php
        $res = $conn->query("SELECT id, name, price, image FROM products");
        while ($row = $res->fetch_assoc()) {
          $img = !empty($row['image']) ? "uploads/" . htmlspecialchars($row['image']) : "uploads/placeholder.png";
          echo "
          <div class='product-card'
            data-id='" . intval($row['id']) . "'
            data-name='" . htmlspecialchars($row['name'], ENT_QUOTES) . "'
            data-price='" . floatval($row['price']) . "'>
            <img src='" . htmlspecialchars($img, ENT_QUOTES) . "' alt='" . htmlspecialchars($row['name'], ENT_QUOTES) . "' />
            <p class='product-name'>" . htmlspecialchars($row['name']) . "</p>
            <p class='product-price'>৳" . number_format($row['price'], 2) . "</p>
          </div>";
        }
        ?>
      </div>
    </div>

    <!-- ✅ Cart Section -->
    <div class="cart">
      <h3>🧾 Cart</h3>
      <div class="cart-items-container">
        <table id="cartTable" width="100%">
          <thead>
            <tr>
              <th>Product</th>
              <th>Qty</th>
              <th>Price</th>
              <th>Total</th>
              <th>❌</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <div class="cart-footer">
        <h3>Total: ৳<span id="grandTotal">0.00</span></h3>
        <div id="actionButtons" style="display:flex; gap:8px;"></div>
      </div>
    </div>
  </div>
</div>

<style>
/* 🌟 Layout */
.order-container {
  display: flex;
  gap: 20px;
  margin-top: 10px;
  align-items: flex-start;
}

/* ✅ Product Section */
.products-list {
  flex: 1;
  background: #fff;
  padding: 12px;
  border-radius: 10px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.05);
  max-height: 85vh;
  overflow-y: auto;
}

.products-list h2 {
  margin-bottom: 10px;
  font-size: 18px;
  color: #333;
  text-align: center;
}

.products-container {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
  gap: 8px;
}

.product-card {
  border: 1px solid #ddd;
  border-radius: 6px;
  padding: 6px;
  text-align: center;
  cursor: pointer;
  transition: all 0.2s;
  background: #fafafa;
}

.product-card:hover {
  background: #f0f8ff;
  transform: scale(1.03);
}

.product-card img {
  width: 100%;
  height: 70px;
  object-fit: cover;
  border-radius: 5px;
  margin-bottom: 4px;
}

.product-name {
  font-size: 13px;
  font-weight: 500;
  margin-bottom: 2px;
}

.product-price {
  font-size: 12px;
  color: #007bff;
  font-weight: 600;
}

/* ✅ Fixed Cart */
.cart {
  width: 420px; /* Increased width for better spacing */
  min-width: 400px;
  background: #fff;
  padding: 15px;
  border-radius: 10px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.05);
  display: flex;
  flex-direction: column;
  height: 85vh;
  position: sticky;
  top: 10px;
  overflow: hidden;
}

.cart h3 {
  margin-bottom: 8px;
  text-align: center;
}

/* ✅ Table inside Cart */
.cart-items-container {
  flex: 1;
  overflow-y: auto;
  overflow-x: hidden;
  border-top: 1px solid #eee;
  border-bottom: 1px solid #eee;
  padding-top: 8px;
  margin-bottom: 8px;
}

#cartTable {
  width: 100%;
  border-collapse: collapse;
  table-layout: fixed;
  font-size: 13px;
}

#cartTable th, #cartTable td {
  border: 1px solid #eee;
  padding: 4px;
  text-align: center;
  white-space: nowrap;
}

#cartTable th {
  background-color: #f0f8ff;
  color: #007bff; /* 💙 Blue header titles */
  font-weight: 600;
}

#cartTable th:nth-child(1), #cartTable td:nth-child(1) {
  text-align: left;
  padding-left: 6px;
}

#cartTable th:nth-child(2), #cartTable td:nth-child(2) {
  width: 35px;
}

#cartTable th:nth-child(3), #cartTable td:nth-child(3),
#cartTable th:nth-child(4), #cartTable td:nth-child(4) {
  width: 60px;
}

#cartTable th:nth-child(5), #cartTable td:nth-child(5) {
  width: 30px;
  text-align: center;
}

/* ❌ Delete button */
.delete-btn {
  background: none;
  border: none;
  color: red;
  font-size: 15px;
  cursor: pointer;
  padding: 0;
  line-height: 1;
}
.delete-btn:hover {
  color: darkred;
}

/* ✅ Footer */
.cart-footer {
  padding-top: 10px;
  border-top: 1px solid #eee;
  background: #fff;
  position: sticky;
  bottom: 0;
}

/* ✅ Buttons */
button {
  padding: 8px 10px;
  border-radius: 6px;
  border: none;
  background: #007bff;
  color: #fff;
  cursor: pointer;
  font-weight: 600;
}
button:hover {
  background: #0056b3;
}

/* 🌈 Responsive */
@media (max-width: 1024px) {
  .order-container {
    flex-direction: column;
  }
  .cart {
    width: 100%;
    height: 60vh;
    position: relative;
    top: auto;
  }
  .products-container {
    grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
  }
}

@media (max-width: 600px) {
  .products-container {
    grid-template-columns: repeat(2, 1fr);
  }
  .cart {
    height: 55vh;
    width: 100%;
  }
}
</style>

<script src="order.js"></script>
<script>
setTimeout(function() {
  if (typeof initOrderPage === "function") {
    initOrderPage(<?php echo json_encode($table); ?>, <?php echo json_encode($type); ?>);
  }

  const checkoutBtn = document.getElementById("checkoutBtn");
  if (checkoutBtn) {
    checkoutBtn.addEventListener("click", function() {
      if (!window.cart || window.cart.length === 0) {
        alert("Cart is empty!");
        return;
      }
      sessionStorage.setItem("currentCart", JSON.stringify(window.cart));
      sessionStorage.setItem("currentTable", <?php echo json_encode($table); ?>);
      sessionStorage.setItem("orderType", <?php echo json_encode($type); ?>);
      window.location.href = `checkout.php?table=<?php echo $table; ?>&type=<?php echo $type; ?>`;
    });
  }
}, 100);
</script>
