<?php
session_start();
include "db.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Order Pad</title>
<style>
body, html {
  margin:0; padding:0;
  font-family:Arial, sans-serif;
  background:#f7f7f7; height:100vh;
}
.orderpad-container {
  display:flex; height:100vh;
}
/* LEFT PANEL */
.left-panel {
  flex:1;
  background:#fff;
  border-right:1px solid #ddd;
  padding:20px;
  overflow-y:auto;
}
.left-header {
  display:flex;
  justify-content:space-between;
  align-items:center;
}
.create-btn {
  background:#007bff; color:#fff;
  padding:8px 14px;
  border:none; border-radius:6px;
  cursor:pointer; transition:0.2s;
}
.create-btn:hover { background:#0069d9; }

#newProductForm {
  margin-top:15px; background:#f1f1f1;
  padding:15px; border-radius:8px; display:none;
}
#newProductForm input, #newProductForm select {
  width:100%; padding:10px; margin-bottom:10px;
  border:1px solid #ccc; border-radius:6px;
}
.add-btn {
  background:#28a745; color:#fff;
  border:none; padding:10px 14px;
  border-radius:6px; cursor:pointer;
}
.add-btn:hover { background:#218838; }

.product-item {
  background:#fafafa; border:1px solid #ddd;
  border-radius:6px; padding:10px; margin-bottom:8px;
  display:flex; justify-content:space-between;
  align-items:center;
}
.icon-btn {
  background:none; border:none;
  cursor:pointer; font-size:18px; margin-left:10px;
}
.icon-btn:hover { transform:scale(1.2); }

/* RIGHT PANEL */
.right-panel {
  flex:2; background:#fff; padding:20px;
  overflow-y:auto;
}
.source-cart {
  margin-bottom:25px;
}
.source-cart h3 {
  margin-top:0;
  padding:10px; border-radius:8px;
  color:#fff;
}
.qbistro { background:#28a745; }
.local { background:#ffc107; color:#222; }
.other { background:#007bff; }

.cart-table {
  width:100%; border-collapse:collapse;
  margin-top:5px;
}
.cart-table th, .cart-table td {
  border:1px solid #ddd; padding:8px; text-align:center;
}
.delete-cart {
  color:red; cursor:pointer;
}
.action-buttons {
  margin-top:10px; display:flex; gap:10px;
}
.action-buttons button {
  padding:8px 12px;
  border:none; border-radius:6px;
  cursor:pointer; font-size:14px;
}
.clear-btn { background:#dc3545; color:#fff; }
.print-btn { background:#28a745; color:#fff; }
.clear-btn:hover { background:#b02a37; }
.print-btn:hover { background:#218838; }
</style>
</head>
<body>

<div class="orderpad-container">
  <!-- LEFT PANEL -->
  <div class="left-panel">
    <div class="left-header">
      <h2>🧾 Order Pad</h2>
      <button class="create-btn" id="createBtn">➕ Create New Product</button>
    </div>

    <div id="newProductForm">
      <input type="text" id="productName" placeholder="Enter product name">
      <select id="productSource">
        <option value="">-- Select Source --</option>
        <option value="Qbistro">Q Bistro</option>
        <option value="LocalMarket">Local Market</option>
        <option value="Other">Other Source</option>
      </select>
      <button class="add-btn" id="addProductBtn">Add Product</button>
    </div>

    <div class="product-list" id="productList">
      <p>Loading products...</p>
    </div>
  </div>

  <!-- RIGHT PANEL -->
  <div class="right-panel">
    <div class="source-cart">
      <h3 class="qbistro">🟢 Q Bistro</h3>
      <div class="action-buttons">
        <button class="clear-btn" onclick="clearCategory('Qbistro')">🧹 Clear All</button>
        <button class="print-btn" onclick="printCategory('Qbistro')">🖨️ Print</button>
      </div>
      <table class="cart-table" id="cartQbistro">
        <thead><tr><th>Product</th><th>Qty</th><th>Action</th></tr></thead>
        <tbody></tbody>
      </table>
    </div>

    <div class="source-cart">
      <h3 class="local">🟠 Local Market</h3>
      <div class="action-buttons">
        <button class="clear-btn" onclick="clearCategory('LocalMarket')">🧹 Clear All</button>
        <button class="print-btn" onclick="printCategory('LocalMarket')">🖨️ Print</button>
      </div>
      <table class="cart-table" id="cartLocal">
        <thead><tr><th>Product</th><th>Qty</th><th>Action</th></tr></thead>
        <tbody></tbody>
      </table>
    </div>

    <div class="source-cart">
      <h3 class="other">🔵 Other Source</h3>
      <div class="action-buttons">
        <button class="clear-btn" onclick="clearCategory('Other')">🧹 Clear All</button>
        <button class="print-btn" onclick="printCategory('Other')">🖨️ Print</button>
      </div>
      <table class="cart-table" id="cartOther">
        <thead><tr><th>Product</th><th>Qty</th><th>Action</th></tr></thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</div>

<script>
document.getElementById("createBtn").addEventListener("click", () => {
  const form = document.getElementById("newProductForm");
  form.style.display = form.style.display === "none" ? "block" : "none";
});

// Add new product
document.getElementById("addProductBtn").addEventListener("click", async () => {
  const name = document.getElementById("productName").value.trim();
  const source = document.getElementById("productSource").value.trim();
  if (!name || !source) return alert("Please enter product name and select source!");

  const res = await fetch("save_product.php", {
    method: "POST",
    headers: {"Content-Type": "application/json"},
    body: JSON.stringify({ name, source })
  });
  const result = await res.json();
  if (result.success) {
    alert("✅ Product added!");
    document.getElementById("productName").value = "";
    document.getElementById("productSource").value = "";
    document.getElementById("newProductForm").style.display = "none";
    loadProducts();
  } else alert("❌ " + result.message);
});

async function loadProducts() {
  const res = await fetch("get_products.php");
  const data = await res.json();
  const list = document.getElementById("productList");
  list.innerHTML = "";
  if (data.length === 0) return list.innerHTML = "<p>No products yet.</p>";
  data.forEach(p => {
    const div = document.createElement("div");
    div.className = "product-item";
    div.innerHTML = `
      <div><b>${p.p_product_name}</b><br><small>${p.source}</small></div>
      <div>
        <button class="icon-btn" onclick="openQty(${p.id}, '${p.p_product_name}', '${p.source}')">✔️</button>
        <button class="icon-btn" onclick="deleteProduct(${p.id})">❌</button>
      </div>
    `;
    list.appendChild(div);
  });
}

async function openQty(id, name, source) {
  const qty = prompt("Enter quantity for " + name + ":");
  if (qty && qty.trim() !== "") {
    const res = await fetch("save_order_product.php", {
      method: "POST",
      headers: {"Content-Type": "application/json"},
      body: JSON.stringify({ id, name, source, qty })
    });
    const result = await res.json();
    if (result.success) {
      alert("✅ Added to order!");
      loadOrderCarts();
    } else {
      alert("❌ Error adding order: " + result.message);
    }
  }
}

// Delete from product master
async function deleteProduct(id) {
  if (!confirm("Delete this product?")) return;
  const res = await fetch("delete_product.php?id=" + id);
  const result = await res.json();
  if (result.success) loadProducts();
  else alert("❌ " + result.message);
}

// Load carts by source
async function loadOrderCarts() {
  const res = await fetch("get_order_products.php");
  const data = await res.json();

  const qb = document.querySelector("#cartQbistro tbody");
  const lm = document.querySelector("#cartLocal tbody");
  const oth = document.querySelector("#cartOther tbody");
  qb.innerHTML = lm.innerHTML = oth.innerHTML = "";

  data.forEach(item => {
    const row = document.createElement("tr");
    row.innerHTML = `
      <td>${item.product_name}</td>
      <td>${item.qty}</td>
      <td><span class="delete-cart" onclick="deleteOrder(${item.id})">❌</span></td>
    `;
    if (item.source === "Qbistro") qb.appendChild(row);
    else if (item.source === "LocalMarket") lm.appendChild(row);
    else oth.appendChild(row);
  });
}

// Delete one from order cart
async function deleteOrder(id) {
  if (!confirm("Remove from cart?")) return;
  const res = await fetch("delete_order_product.php?id=" + id);
  const result = await res.json();
  if (result.success) loadOrderCarts();
  else alert("❌ " + result.message);
}

// Clear all for category
async function clearCategory(source) {
  if (!confirm("Clear all items for " + source + "?")) return;
  const res = await fetch("clear_category.php?source=" + source);
  const result = await res.json();
  if (result.success) loadOrderCarts();
  else alert("❌ " + result.message);
}

// Print a category receipt (RawBT)
function printCategory(source) {
  window.location.href = "print_orderpad_category.php?source=" + encodeURIComponent(source);
}

loadProducts();
loadOrderCarts();
</script>
</body>
</html>
