<?php
session_start();
if (!isset($_SESSION['username'])) {
    header("Location: login.html");
    exit();
}

$userRole = $_SESSION['role']; // admin / manager / staff

include "db.php";

if (!isset($_GET['order_id'])) {
    die("No order ID provided.");
}

$order_id = intval($_GET['order_id']);

// 🧾 Get order info
$order_sql = "SELECT * FROM orders WHERE id = $order_id";
$order_result = $conn->query($order_sql);
$order = $order_result ? $order_result->fetch_assoc() : null;

if (!$order) {
    die("Order not found.");
}

// 🍔 Get order items
$item_sql = "SELECT * FROM order_items WHERE order_id = $order_id";
$item_result = $conn->query($item_sql);
$items = [];
if ($item_result) {
    while ($row = $item_result->fetch_assoc()) {
        $items[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Order Details</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body {
    font-family: "Segoe UI", Arial, sans-serif;
    background: #f8f9fa;
    margin: 0;
    padding: 0;
}
.container {
    max-width: 800px;
    margin: 20px auto;
    background: white;
    border-radius: 10px;
    box-shadow: 0 3px 8px rgba(0,0,0,0.1);
    padding: 20px;
}
h2 {
    text-align: center;
    background: #007bff;
    color: white;
    padding: 12px;
    border-radius: 8px;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
}
th, td {
    border: 1px solid #ddd;
    padding: 10px;
}
th {
    background: #f1f1f1;
}
button {
    background: #007bff;
    color: white;
    border: none;
    padding: 10px 15px;
    border-radius: 5px;
    margin: 5px;
    cursor: pointer;
    transition: 0.3s;
}
button:hover { background: #0056b3; }
.btn-delete { background: #dc3545; }
.btn-delete:hover { background: #b52a38; }
.btn-print { background: #28a745; }
.btn-print:hover { background: #1e7e34; }
.btn-update { background: #ffc107; color: black; }
</style>
</head>
<body>

<div class="container">
    <h2>🧾 Order #<?= htmlspecialchars($order['id']) ?></h2>
    <p>
        <strong>Customer:</strong> <?= htmlspecialchars($order['customer_name']) ?><br>
        <strong>Phone:</strong> <?= htmlspecialchars($order['customer_phone']) ?><br>
        <strong>Order Type:</strong> <?= ucfirst($order['order_type']) ?><br>
        <strong>Payment Type:</strong> <?= ucfirst($order['payment_type']) ?><br>
        <strong>Date:</strong> <?= date("d M Y, h:i A", strtotime($order['created_at'])) ?>
    </p>

    <table>
        <thead>
            <tr><th>Item</th><th>Qty</th><th>Price</th><th>Total</th></tr>
        </thead>
        <tbody>
            <?php if (count($items) > 0): ?>
                <?php foreach ($items as $item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['product_name'] ?? '') ?></td>
                    <td><?= (int)($item['qty'] ?? 0) ?></td>
                    <td>৳<?= number_format($item['price'] ?? 0, 2) ?></td>
                    <td>৳<?= number_format(($item['qty'] ?? 0) * ($item['price'] ?? 0), 2) ?></td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="4" style="text-align:center;">No items found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="btn-group" style="text-align:center; margin-top:20px;">
        <button id="printBtn" class="btn-print">🖨️ Print</button>
        <button id="updateBtn" class="btn-update">✏️ Update</button>

        <?php if ($userRole === "admin"): ?>
            <button id="deleteBtn" class="btn-delete">🗑️ Delete</button>
        <?php endif; ?>
    </div>
</div>

<script>
// ========================
// ✅ Initialize Page Logic
// ========================
(function initOrderDetails() {
    const printBtn = document.getElementById("printBtn");
    const updateBtn = document.getElementById("updateBtn");
    const orderId = <?= (int)$order['id'] ?>;
    const orderType = "<?= strtolower(trim($order['order_type'])) ?>";

    // 🖨️ PRINT
    printBtn.addEventListener("click", () => {
        const printUrl = (orderType === "collection")
            ? "print_collection.php?id=" + orderId
            : "bill_receipt.php?order_id=" + orderId;
        window.open(printUrl, "_blank");
    });

    // ✏️ UPDATE
    updateBtn.addEventListener("click", () => {
        if (orderType === "dinein") {
            alert("🍽️ Dine-in order cannot be updated.");
            return;
        }

        fetch("prepare_edit_order.php?order_id=" + orderId)
            .then(r => r.json())
            .then(data => {
                if (data.status !== "success") {
                    alert("❌ " + data.message);
                    return;
                }

                localStorage.setItem("editOrderData", JSON.stringify(data.order));

                const mainContent = document.getElementById("mainContent");

                if (mainContent) {
                    fetch("collection_editable.php?edit=" + orderId)
                        .then(r => r.text())
                        .then(html => {
                            mainContent.innerHTML = html;
                            window.scrollTo(0, 0);

                            const scripts = mainContent.querySelectorAll("script");
                            scripts.forEach(s => {
                                const ns = document.createElement("script");
                                if (s.src) ns.src = s.src;
                                else ns.textContent = s.textContent;
                                document.body.appendChild(ns);
                            });

                            setTimeout(() => {
                                if (typeof initCollectionEditablePage === "function") {
                                    initCollectionEditablePage();
                                }
                            }, 700);
                        })
                        .catch(() => {
                            window.location.href = "collection_editable.php?edit=" + orderId;
                        });
                } else {
                    window.location.href = "collection_editable.php?edit=" + orderId;
                }
            });
    });

    // 🗑️ DELETE (ONLY if admin button exists)
    const deleteBtn = document.getElementById("deleteBtn");
    if (deleteBtn) {
        deleteBtn.addEventListener("click", () => {
            if (!confirm("⚠️ Delete this order?")) return;

            fetch("delete_order.php?order_id=" + orderId)
                .then(r => r.json())
                .then(data => {
                    if (data.status === "success") {
                        alert("✅ " + data.message);
                        setTimeout(() => {
                            window.location.href = "dashboard.php";
                        }, 1500);
                    } else {
                        alert("❌ " + data.message);
                    }
                })
                .catch(err => {
                    alert("❌ Error: " + err);
                });
        });
    }
})();
</script>

</body>
</html>
