<?php
session_start();
if (!isset($_SESSION['username'])) {
  header("Location: login.html");
  exit();
}

$userRole = $_SESSION['role']; // admin, manager, staff

// 🔹 DB Connection
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
  die("DB connection failed: " . $conn->connect_error);
}

$year  = date("Y");
$month = date("m");
$monthName = date("F");

// 🔹 Admin sees whole month
if ($userRole === "admin") {
    $sql = "SELECT id, customer_name, customer_phone, final_total, discount, tip, payment_type, order_type, created_at 
            FROM orders 
            WHERE YEAR(created_at) = $year AND MONTH(created_at) = $month 
            ORDER BY created_at DESC";

}
// 🔹 Manager or Staff see TODAY ONLY
else {
    $today = date("Y-m-d");
    $sql = "SELECT id, customer_name, customer_phone, final_total, discount, tip, payment_type, order_type, created_at 
            FROM orders 
            WHERE DATE(created_at) = '$today'
            ORDER BY created_at DESC";
}

$result = $conn->query($sql);
$orders = [];
if ($result) {
  while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
  }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Order List</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body {
  margin: 0;
  padding: 0;
  background: #f5f6fa;
  font-family: "Segoe UI", Arial, sans-serif;
}
.order-list-container {
  max-width: 1000px;
  margin: 0 auto;
  padding: 0;
}
.order-list-container h2 {
  text-align: center;
  background: #007bff;
  color: white;
  margin: 0;
  padding: 15px;
  font-size: 20px;
}
.order-list-container table {
  width: 100%;
  border-collapse: collapse;
  background: #fff;
}
.order-list-container th, .order-list-container td {
  padding: 10px;
  border: 1px solid #ddd;
  font-size: 14px;
  text-align: left;
}
.order-list-container th {
  background: #007bff;
  color: white;
}
.order-list-container tr.date-row td {
  background: #f1f1f1;
  font-weight: bold;
  text-align: center;
  font-size: 15px;
}
.order-list-container tr.clickable:hover {
  background: #e8f0ff;
  cursor: pointer;
}
</style>
</head>
<body>
<div class="order-list-container">

  <h2>
    📃 
    <?php 
      if ($userRole === "admin") echo "Orders for $monthName $year";
      else echo "Today's Orders (" . date("d M Y") . ")";
    ?>
  </h2>

  <table>
    <thead>
      <tr>
        <th>Customer Name</th>
        <th>Total (৳)</th>
        <th>Payment Type</th>
        <th>Order Type</th>
        <th>Date & Time</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $lastDate = null;
      foreach ($orders as $order) {

        $dateOnly = date("d M Y", strtotime($order['created_at']));
        $dateTime = date("d M Y — h:i A", strtotime($order['created_at']));

        // 🟦 Only show date headers for ADMIN (month view)
        if ($userRole === "admin") {
            if ($dateOnly !== $lastDate) {
              echo "<tr class='date-row'><td colspan='5'>📅 $dateOnly</td></tr>";
              $lastDate = $dateOnly;
            }
        }

        echo "
          <tr class='clickable' data-id='{$order['id']}'>
            <td>" . htmlspecialchars($order['customer_name']) . "</td>
            <td>৳" . number_format($order['final_total'], 2) . "</td>
            <td>" . htmlspecialchars(ucfirst($order['payment_type'])) . "</td>
            <td>" . htmlspecialchars(ucfirst($order['order_type'])) . "</td>
            <td>$dateTime</td>
          </tr>
        ";
      }

      if (empty($orders)) {
        echo "<tr><td colspan='5' style='text-align:center;'>No orders found.</td></tr>";
      }
      ?>
    </tbody>
  </table>
</div>

<script>
document.addEventListener("click", function(e) {
  const row = e.target.closest("tr.clickable");
  if (row) {
    const orderId = row.dataset.id;
    if (orderId) {
      const mainContent = document.getElementById("mainContent");
      const detailsPage = "order_list_details_new.php?order_id=" + orderId;
      if (mainContent) {
        fetch(detailsPage)
          .then(r => r.text())
          .then(html => {
            mainContent.innerHTML = html;
            const scripts = mainContent.querySelectorAll("script");
            scripts.forEach(oldScript => {
              const newScript = document.createElement("script");
              if (oldScript.src) newScript.src = oldScript.src;
              else newScript.textContent = oldScript.textContent;
              document.body.appendChild(newScript);
              oldScript.remove();
            });
            window.scrollTo(0, 0);
          })
          .catch(() => { window.location.href = detailsPage; });
      } else {
        window.location.href = detailsPage;
      }
    }
  }
});
</script>
</body>
</html>
