<?php
session_start();

// // ✅ DB connect
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db   = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("❌ DB connection failed");
}

$order_id = intval($_GET['order_id'] ?? 0);
if ($order_id <= 0) {
    die("❌ Invalid order ID");
}

// ✅ Fetch order
$sql = "SELECT * FROM orders WHERE id=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$res = $stmt->get_result();
$order = $res->fetch_assoc();
$stmt->close();

if (!$order) {
    die("❌ Order not found");
}

// ✅ Fetch items
$sql = "SELECT * FROM order_items WHERE order_id=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$resItems = $stmt->get_result();
$items = [];
while ($row = $resItems->fetch_assoc()) {
    $items[] = $row;
}
$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Order Details</title>
<style>
body { font-family: Arial, sans-serif; padding:20px; }
h2 { margin-bottom:10px; }
table { width:100%; border-collapse: collapse; margin-top:15px; }
table th, table td { border:1px solid #ccc; padding:8px; text-align:left; }
.actions { margin-top:15px; text-align:right; }
button { padding:8px 12px; border:none; border-radius:5px; cursor:pointer; margin-left:8px; }
.update-btn { background:#007bff; color:white; }
.delete-btn { background:#dc3545; color:white; }
</style>
</head>
<body>
  <h2>Order #<?php echo $order['id']; ?></h2>
  <p><strong>Customer:</strong> <?php echo htmlspecialchars($order['customer_name']); ?></p>
  <p><strong>Phone:</strong> <?php echo htmlspecialchars($order['customer_phone']); ?></p>
  <p><strong>Payment:</strong> <?php echo htmlspecialchars($order['payment_type']); ?></p>
  <p><strong>Subtotal:</strong> ৳<?php echo number_format($order['subtotal'],2); ?></p>
  <p><strong>Discount:</strong> ৳<?php echo number_format($order['discount'],2); ?></p>
  <p><strong>Tips:</strong> ৳<?php echo number_format($order['tip'],2); ?></p>
  <p><strong>Final Total:</strong> ৳<?php echo number_format($order['final_total'],2); ?></p>

  <h3>Items</h3>
  <table>
    <tr><th>Product</th><th>Qty</th><th>Price</th><th>Total</th></tr>
    <?php foreach($items as $it): ?>
      <tr>
        <td><?php echo htmlspecialchars($it['product_name']); ?></td>
        <td><?php echo $it['qty']; ?></td>
        <td>৳<?php echo number_format($it['price'],2); ?></td>
        <td>৳<?php echo number_format($it['total'],2); ?></td>
      </tr>
    <?php endforeach; ?>
  </table>

<input type="hidden" id="popup_order_id" value="<?= $order_id ?>">
<input type="hidden" id="popup_order_type" value="<?= htmlspecialchars($order_type) ?>">
<button onclick="updateOrder(<?= $order_id ?>)" style="background:#28a745;color:white;border:none;padding:8px 15px;border-radius:5px;cursor:pointer;">
  ✏️ Update
</button>
<button onclick="deleteOrder(<?= $order_id ?>)" style="background:#dc3545;color:white;border:none;padding:8px 15px;border-radius:5px;cursor:pointer;">
  🗑 Delete
</button>


  <!-- Buttons always visible -->
  <!-- <div class="actions">
    <button class="update-btn" onclick="updateOrder(<?php echo $order_id; ?>)">✏️ Update</button>
    <button class="delete-btn" onclick="deleteOrder(<?php echo $order_id; ?>)">🗑 Delete</button>
  </div> -->

<script>
function updateOrder(orderId) {
    <?php if (!empty($_SESSION['username']) && strtolower($_SESSION['admin']) === 'admin') { ?>
        alert("✅ Admin: Update order " + orderId + " (implement update form here).");
    <?php } else { ?>
        alert("❌ Only admin can access this function.");
    <?php } ?>
}

function deleteOrder(orderId) {
    <?php if (!empty($_SESSION['username']) && strtolower($_SESSION['admin']) === 'admin') { ?>
        if(confirm("Are you sure you want to delete this order?")) {
            fetch("delete_order.php?id=" + orderId, { method:"POST" })
            .then(res => res.json())
            .then(data => {
                alert(data.message);
                if(data.status === "success") {
                    window.close(); // or refresh parent
                }
            });
        }
    <?php } else { ?>
        alert("❌ Only admin can access this function.");
    <?php } ?>
}
</script>
</body>
</html>
