<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

session_start();

// Database connection
// $conn = new mysqli("localhost", "root", "", "restaurant_pos");


// 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";

include "db.php";


if ($conn->connect_error) {
    die("DB Connection failed: " . $conn->connect_error);
}

// ✅ Sanitize input
$username = trim($_POST['username'] ?? '');
$password = trim($_POST['password'] ?? '');

if (empty($username) || empty($password)) {
    die("⚠️ Username and password are required!");
}

// ✅ Fetch user by username
$sql = "SELECT id, username, password, role FROM users WHERE username=? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows === 1) {
    $user = $result->fetch_assoc();

    // ✅ Verify password
    if (password_verify($password, $user['password'])) {
        // ✅ Store session values
        $_SESSION['user_id']  = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role']     = $user['role']; // 👈 admin, manager, staff, etc.

        // ✅ Redirect by role
        if ($user['role'] === 'admin') {
            header("Location: dashboard.php");
        } elseif ($user['role'] === 'manager') {
            header("Location: dashboard.php");
        } else {
            header("Location: dashboard.php");
        }
        exit();
    } else {
        echo "❌ Invalid password!";
    }
} else {
    echo "❌ User not found!";
}

$stmt->close();
$conn->close();
?>
