<?php
// load_order.php
header('Content-Type: application/json; charset=utf-8');

// $host="localhost"; $user="root"; $pass=""; $db="restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

$conn = new mysqli($host,$user,$pass,$db);
if($conn->connect_error){
    echo json_encode(['error'=>'DB error']); exit;
}

$table = intval($_GET['table'] ?? 0);
$cart = [];

if($table > 0){
    // Aggregate existing orders for this table and return quantities per product
    $sql = "SELECT product_id, product_name, price, SUM(qty) AS qty
            FROM orders
            WHERE table_no = ? AND order_type = 'dinein'
            GROUP BY product_id, product_name, price";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $table);
    $stmt->execute();
    $res = $stmt->get_result();
    while($row = $res->fetch_assoc()){
        $cart[] = [
            'id' => intval($row['product_id']),
            'name' => $row['product_name'],
            'price' => floatval($row['price']),
            'qty' => intval($row['qty'])
        ];
    }
    $stmt->close();
}

echo json_encode(['cart' => $cart]);
$conn->close();
