<?php
header('Content-Type: application/json; charset=utf-8');

// // ✅ Database connection
// $host = "localhost";
// $user = "root";
// $pass = "";
// $db   = "restaurant_pos";

// // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "DB Connection Error: " . $conn->connect_error
    ]);
    exit;
}

$table = intval($_GET['table'] ?? 0);

if ($table > 0) {
    // 1️⃣ Fetch cart items for this table
    $sqlItems = "
        SELECT product_id AS id, product_name AS name, qty, price 
        FROM cart_items 
        WHERE table_no=?
    ";
    $stmt = $conn->prepare($sqlItems);
    if (!$stmt) {
        echo json_encode(["status" => "error", "message" => $conn->error]);
        exit;
    }
    $stmt->bind_param("i", $table);
    $stmt->execute();
    $resultItems = $stmt->get_result();

    $cart = [];
    while ($row = $resultItems->fetch_assoc()) {
        $cart[] = [
            "id"    => intval($row['id']),
            "name"  => $row['name'],
            "qty"   => intval($row['qty']),
            "price" => floatval($row['price'])
        ];
    }
    $stmt->close();

    if (!empty($cart)) {
        echo json_encode([
            "status" => "success",
            "table"  => $table,
            "cart"   => $cart
        ]);
    } else {
        echo json_encode([
            "status" => "empty",
            "cart"   => []
        ]);
    }
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Invalid table number"
    ]);
}

$conn->close();
?>
