<?php include "db.php"; ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Fixed Expense</title>
<style>
body, html {
  margin: 0;
  padding: 0;
  font-family: Arial, sans-serif;
  background: #f5f5f5;
  height: 100vh;
}
.expense-page {
  display: flex;
  height: 100vh;
}

/* LEFT FORM */
.left-panel {
  flex: 1;
  background: #fff;
  padding: 20px;
  border-right: 1px solid #ddd;
}
.left-panel h2 {
  margin-top: 0;
}
.form-group {
  margin-bottom: 15px;
}
.form-group label {
  display: block;
  font-weight: bold;
  margin-bottom: 6px;
}
.form-group input, .form-group select, .form-group textarea {
  width: 100%;
  padding: 10px;
  border: 1px solid #ccc;
  border-radius: 6px;
}
.add-btn {
  background: #28a745;
  color: #fff;
  padding: 10px 15px;
  border: none;
  border-radius: 8px;
  cursor: pointer;
  font-size: 16px;
  transition: 0.2s;
}
.add-btn:hover {
  background: #218838;
}

/* RIGHT LIST */
.right-panel {
  flex: 1.5;
  background: #fff;
  padding: 20px;
  display: flex;
  flex-direction: column;
}
.right-panel h2 {
  margin-top: 0;
}
.expense-list {
  flex: 1;
  overflow-y: auto;
}
table {
  width: 100%;
  border-collapse: collapse;
}
table th, table td {
  border: 1px solid #ddd;
  padding: 8px;
  text-align: center;
}
.delete-btn {
  background: #dc3545;
  color: #fff;
  border: none;
  padding: 6px 10px;
  border-radius: 6px;
  cursor: pointer;
}
.delete-btn:hover {
  background: #c82333;
}
</style>
</head>
<body>

<div class="expense-page">
  <!-- LEFT: Add Expense -->
  <div class="left-panel">
    <h2>Add Fixed Expense</h2>
        <h3>Shop rent,electric bill,wifi bill,tax,generator oil</h3>


    <div class="form-group">
      <label>Expense Name</label>
      <input type="text" id="expenseName" placeholder="e.g., Shop Rent, Electricity Bill">
    </div>

    <div class="form-group">
      <label>Amount (৳)</label>
      <input type="text" id="expenseAmount" placeholder="e.g., 2500 or 1200.50">
    </div>

    <div class="form-group">
      <label>Payment Type</label>
      <select id="paymentType">
        <option value="cash">Cash</option>
        <option value="bank">Bank</option>
      </select>
    </div>

    <div class="form-group">
      <label>Notes</label>
      <textarea id="expenseNotes" rows="3" placeholder="Optional notes..."></textarea>
    </div>

    <button class="add-btn" onclick="addExpense()">➕ Add Expense</button>
  </div>

  <!-- RIGHT: Expense List -->
  <div class="right-panel">
    <h2>Fixed Expense List</h2>
    <div class="expense-list">
      <table id="expenseTable">
        <thead>
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Amount (৳)</th>
            <th>Payment</th>
            <th>Notes</th>
            <th>Date</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</div>

<script>
async function loadExpenses(){
  let res = await fetch('get_fixed_expense.php');
  let data = await res.json();
  let tbody = document.querySelector("#expenseTable tbody");
  tbody.innerHTML = "";
  data.forEach((ex, i) => {
    let tr = document.createElement("tr");
    tr.innerHTML = `
      <td>${i+1}</td>
      <td>${ex.expense_name}</td>
      <td>৳${parseFloat(ex.amount).toFixed(2)}</td>
      <td>${ex.payment_type}</td>
      <td>${ex.notes || ''}</td>
      <td>${ex.created_at}</td>
      <td><button class="delete-btn" onclick="deleteExpense(${ex.id})">🗑️</button></td>
    `;
    tbody.appendChild(tr);
  });
}

async function addExpense(){
  let name = document.getElementById("expenseName").value.trim();
  let amount = document.getElementById("expenseAmount").value.trim();
  let type = document.getElementById("paymentType").value;
  let notes = document.getElementById("expenseNotes").value.trim();

  if(!name || !amount){
    alert("Please enter expense name and amount!");
    return;
  }

  let data = {name, amount, type, notes};
  let res = await fetch("save_fixed_expense.php", {
    method: "POST",
    headers: {"Content-Type":"application/json"},
    body: JSON.stringify(data)
  });
  let result = await res.json();
  if(result.success){
    document.getElementById("expenseName").value = "";
    document.getElementById("expenseAmount").value = "";
    document.getElementById("expenseNotes").value = "";
    loadExpenses();
  } else {
    alert("Error adding expense: " + result.message);
  }
}

async function deleteExpense(id){
  if(!confirm("Are you sure you want to delete this expense?")) return;
  let res = await fetch("delete_fixed_expense.php?id=" + id);
  let result = await res.json();
  if(result.success){
    loadExpenses();
  } else {
    alert("Error deleting expense");
  }
}

loadExpenses();
</script>
</body>
</html>
