<?php
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Connection Error: " . $conn->connect_error);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Expenses</title>
  <style>
    body {
      font-family: "Poppins", Arial, sans-serif;
      margin: 0;
      background: #f5f7fa;
    }
    .expense-page {
      display: flex;
      gap: 20px;
      padding: 20px;
      min-height: 100vh;
    }
    /* ✅ Left Form Panel */
    .expense-form {
      flex: 1;
      background: #fff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 3px 8px rgba(0,0,0,0.08);
      display: flex;
      flex-direction: column;
      gap: 16px;
    }
    .expense-form h2 {
      color: #007bff;
      margin-bottom: 10px;
      font-size: 22px;
      border-bottom: 2px solid #007bff;
      padding-bottom: 6px;
    }
    .form-group {
      display: flex;
      flex-direction: column;
      gap: 5px;
    }
    .form-group label {
      font-weight: 600;
      color: #333;
      font-size: 14px;
    }
    .form-group input,
    .form-group textarea,
    .form-group select {
      padding: 10px 12px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 14px;
      transition: border 0.2s, box-shadow 0.2s;
    }
    .form-group input:focus,
    .form-group textarea:focus,
    .form-group select:focus {
      border-color: #007bff;
      box-shadow: 0 0 0 3px rgba(0,123,255,0.1);
      outline: none;
    }
    .expense-form button {
      padding: 12px;
      background: #007bff;
      border: none;
      color: #fff;
      font-weight: 600;
      font-size: 15px;
      border-radius: 6px;
      cursor: pointer;
      transition: 0.2s;
    }
    .expense-form button:hover {
      background: #0056b3;
    }
    /* ✅ Right List Panel */
    .expense-list {
      flex: 2;
      background: #fff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 3px 8px rgba(0,0,0,0.08);
      overflow-y: auto;
    }
    .expense-list h2 {
      color: #007bff;
      font-size: 22px;
      border-bottom: 2px solid #007bff;
      padding-bottom: 6px;
      margin-bottom: 15px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      font-size: 14px;
    }
    th, td {
      border: 1px solid #eee;
      padding: 8px 10px;
      text-align: left;
    }
    th {
      background-color: #eef7ff;
      color: #007bff;
    }
    tr:nth-child(even) {
      background-color: #f9f9f9;
    }
    /* ✅ Responsive */
    @media (max-width: 900px) {
      .expense-page {
        flex-direction: column;
      }
      .expense-form, .expense-list {
        width: 100%;
      }
    }
    /* ✅ Smooth animations */
    .fadeIn {
      animation: fadeIn 0.4s ease-in;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>
<body>
  <div class="expense-page">
    <!-- ✅ Left: Expense Form -->
    <div class="expense-form">
      <h2>Add Expense</h2>
      <form id="expenseForm">
        <div class="form-group">
          <label>Expense Name</label>
          <input type="text" name="expense_name" required placeholder="e.g., Food Supplies">
        </div>
        <div class="form-group">
          <label>Amount (৳)</label>
          <input type="number" name="amount" step="0.01" required placeholder="e.g., 25.50">
        </div>
        <div class="form-group">
          <label>Payment Type</label>
          <select name="payment_type" required>
            <option value="Cash">Cash</option>
            <option value="Card">Card</option>
          </select>
        </div>
        <div class="form-group">
          <label>Notes</label>
          <textarea name="notes" rows="3" placeholder="Optional note..."></textarea>
        </div>
        <button type="submit">💾 Save Expense</button>
      </form>
    </div>

    <!-- ✅ Right: Expense List -->
    <div class="expense-list">
      <h2>Expense List</h2>
      <table id="expenseTable">
        <thead>
          <tr>
            <th>#</th>
            <th>Expense</th>
            <th>Amount (৳)</th>
            <th>Payment</th>
            <th>Notes</th>
            <th>Date</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>

  <script>
    // ✅ Load expense data
    function loadExpenses() {
      fetch('expense_fetch.php')
        .then(res => res.text())
        .then(html => {
          const tbody = document.querySelector('#expenseTable tbody');
          tbody.innerHTML = html;
          tbody.classList.add('fadeIn');
          setTimeout(() => tbody.classList.remove('fadeIn'), 400);
        });
    }

    // ✅ Submit form without reload
    document.getElementById('expenseForm').addEventListener('submit', function(e) {
      e.preventDefault();
      const btn = this.querySelector('button');
      btn.disabled = true;
      btn.textContent = 'Saving...';

      const formData = new FormData(this);

      fetch('expense_add.php', { method: 'POST', body: formData })
        .then(res => res.json()) // ✅ Expect JSON
        .then(data => {
          if (data.success) {
            alert(`✅ ${data.message}\n💰 ${data.type.toUpperCase()} Balance Updated:\nPrevious: ৳${data.previous_balance}\nCurrent: ৳${data.current_balance}`);
            this.reset();
            loadExpenses();
          } else {
            alert(`⚠️ ${data.message}`);
          }
        })
        .catch(err => alert("❌ Network or Server Error: " + err))
        .finally(() => {
          btn.disabled = false;
          btn.textContent = '💾 Save Expense';
        });
    });

    loadExpenses();
  </script>
</body>
</html>
