<div class="form-container">
  <h2>Dine-In Tables</h2>
  <p>Select a table to start or continue the order:</p>
  <div class="tables-container">
    <?php
    // $host = "localhost";
    // $user = "root";
    // $pass = "";
    // $db   = "restaurant_pos";

//     // 🔹 DB connect for live server 
// $host = "localhost";
// $user = "phizixcl_pos_user";
// $pass = "ta2024@sgh.t/?!@";
// $db   = "phizixcl_restaurant_pos";
include "db.php";

    $conn = new mysqli($host, $user, $pass, $db);
    if ($conn->connect_error) die("DB Connection Error: " . $conn->connect_error);

    $res = $conn->query("SELECT * FROM dine_in_tables ORDER BY id ASC");
    while($row = $res->fetch_assoc()){
        $statusClass = ($row['status'] === 'booked') ? 'booked' : '';
        echo "<div class='table-box $statusClass' 
                 data-table='{$row['id']}' 
                 data-status='{$row['status']}' 
                 onclick='selectTable({$row['id']}, \"{$row['status']}\")'>
                 Table {$row['id']}
              </div>";
    }
    ?>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const editData = localStorage.getItem("editOrderData");
  if (editData) {
    const order = JSON.parse(editData);
    localStorage.removeItem("editOrderData");

    window.cart = order.items.map(it => ({
      id: parseInt(it.product_id),
      name: it.product_name,
      price: parseFloat(it.price),
      qty: parseInt(it.qty)
    }));

    if (typeof updateCartTable === "function") updateCartTable();
  }
});
</script>



<style>
.tables-container {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
  gap: 15px;
  margin-top: 20px;
}
.table-box {
  background: #007bff; /* default blue */
  color: #fff;
  padding: 30px 0;
  text-align: center;
  font-size: 18px;
  border-radius: 8px;
  cursor: pointer;
  transition: transform 0.2s, background 0.2s;
}
.table-box:hover {
  background: #0056b3;
  transform: scale(1.05);
}
.table-box.booked {
  background: #dc3545; /* red when booked */
}
</style>

<script>
// ✅ Function to handle table selection
function selectTable(tableNum, status) {
  // If booked, allow reopening order instead of blocking
  if (status === 'booked') {
    if (typeof loadPage === 'function') {
      loadPage('order_page.php?table=' + tableNum + '&type=dinein');
    } else {
      alert("Error: loadPage() not found. Check Dashboard.js is included.");
    }
    return;
  }

  // If free, start a new order
  if (typeof loadPage === 'function') {
    loadPage('order_page.php?table=' + tableNum + '&type=dinein');
    
  } else {
    alert("Error: loadPage() not found. Check Dashboard.js is included.");
  }
}
</script>
