<?php
$cartData = isset($_GET["cart"]) ? json_decode($_GET["cart"], true) : [];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Delivery Checkout</title>

    <style>
        body { font-family: Arial; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 8px; border: 1px solid #ccc; text-align: center; }
        input, select, textarea { width: 100%; padding: 6px; margin-top: 5px; }
        .box { margin-bottom: 20px; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
        .btn { background: green; color: #fff; padding: 10px; width: 100%; border: none; cursor: pointer; }
        .btn:hover { background: darkgreen; }
        h3 { margin: 0 0 10px 0; }
    </style>
</head>
<body>

<h2>Delivery Checkout</h2>


<!-- CUSTOMER INFO -->
<div class="box">
    <h3>Customer Information</h3>

    <label>Name:</label>
    <input type="text" id="customer_name">

    <label>Phone:</label>
    <input type="text" id="customer_phone">

    <label>Address:</label>
    <textarea id="customer_address"></textarea>
</div>


<!-- DELIVERY INFO -->
<div class="box">
    <h3>Delivery Details</h3>

    <label>Rider Name:</label>
    <input type="text" id="rider_name">

    <label>Rider Mobile:</label>
    <input type="text" id="rider_mobile">

    <label>Delivery Time:</label>
    <input type="time" id="delivery_time">

    <label>Delivery Charge:</label>
    <input type="number" id="delivery_charge" value="0" step="0.01">
</div>


<!-- CART ITEMS -->
<div class="box">
    <h3>Order Items</h3>

    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody id="cartTableBody"></tbody>
    </table>

    <h3>Subtotal: ৳ <span id="subtotal">0</span></h3>

    <label>Discount:</label>
    <input type="number" id="discount" value="0" step="0.01">

    <label>Tip:</label>
    <input type="number" id="tip" value="0" step="0.01">

    <h2>Final Total: ৳ <span id="final_total">0</span></h2>
</div>


<!-- PAYMENT -->
<div class="box">
    <h3>Payment Type</h3>
    <select id="payment_type">
        <option value="cash">Cash</option>
        <option value="bank">Bank</option>
        <option value="bkash">Bkash</option>
        <option value="card">Card</option>
    </select>
</div>


<!-- SUBMIT -->
<button class="btn" onclick="submitDeliveryOrder()">Submit Delivery Order</button>



<script>
// ------------------------------
// LOAD CART
// ------------------------------
let cart = <?= json_encode($cartData) ?>;

function loadCart() {
    const tbody = document.getElementById("cartTableBody");
    tbody.innerHTML = "";

    let subtotal = 0;

    cart.forEach(item => {
        let rowTotal = item.qty * item.price;
        subtotal += rowTotal;

        tbody.innerHTML += `
            <tr>
                <td>${item.name}</td>
                <td>${item.qty}</td>
                <td>${item.price.toFixed(2)}</td>
                <td>${rowTotal.toFixed(2)}</td>
            </tr>
        `;
    });

    document.getElementById("subtotal").innerText = subtotal.toFixed(2);
    calculateFinal();
}

function calculateFinal() {
    let subtotal = parseFloat(document.getElementById("subtotal").innerText);
    let discount = parseFloat(document.getElementById("discount").value);
    let tip = parseFloat(document.getElementById("tip").value);

    let finalTotal = subtotal - discount + tip;
    document.getElementById("final_total").innerText = finalTotal.toFixed(2);
}

document.getElementById("discount").oninput = calculateFinal;
document.getElementById("tip").oninput = calculateFinal;

loadCart();


// ------------------------------
// SUBMIT (NOW SEND JSON)
// ------------------------------
function submitDeliveryOrder() {

    let sendData = {
        name: document.getElementById("customer_name").value,
        phone: document.getElementById("customer_phone").value,
        address: document.getElementById("customer_address").value,

        payment: document.getElementById("payment_type").value,

        subtotal: document.getElementById("subtotal").innerText,
        discount: document.getElementById("discount").value,
        tip: document.getElementById("tip").value,
        final_total: document.getElementById("final_total").innerText,

        rider: document.getElementById("rider_name").value,
        rider_mobile: document.getElementById("rider_mobile").value,
        delivery_time: document.getElementById("delivery_time").value,
        delivery_charge: document.getElementById("delivery_charge").value,

        cart: cart
    };

    fetch("save_delivery_order.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(sendData)
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        window.location.href = "dashboard.php";
    });
}
</script>

</body>
</html>
