<?php
session_start();
include "db.php";

// 🔹 Check if we're editing a delivery order
$editOrder = null;
if (isset($_GET['edit']) && isset($_SESSION['edit_delivery'])) {
    $editOrder = $_SESSION['edit_delivery'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Delivery Order</title>

<script>
document.addEventListener("DOMContentLoaded", () => {
    <?php if ($editOrder): ?>
        const order = <?= json_encode($editOrder, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>;

        // Load cart for editing
        window.deliveryCart = order.items.map(it => ({
            id: parseInt(it.product_id),
            name: it.product_name,
            price: parseFloat(it.price),
            qty: parseInt(it.qty)
        }));

        if (typeof updateDeliveryCartTable === "function") updateDeliveryCartTable();

        localStorage.setItem("editDeliveryName", order.customer_name);
        localStorage.setItem("editDeliveryPhone", order.customer_phone);
        localStorage.setItem("editDeliveryAddress", order.customer_address);
        localStorage.setItem("editDeliveryId", order.order_id);

    <?php else: ?>
        window.deliveryCart = [];
    <?php endif; ?>
});
</script>

<style>
/* SAME DESIGN AS COLLECTION PAGE — DO NOT CHANGE */
body, html { margin: 0; padding: 0; height: 100%; font-family: Arial, sans-serif; }
.order-page { display: flex; height: 100vh; }

/* LEFT: Products */
.products-section { flex: 2; display: flex; flex-direction: column; border-right: 1px solid #ddd; overflow: hidden; }
.products-header { padding: 8px 10px; background: #f8f8f8; border-bottom: 1px solid #ddd; position: sticky; top: 0; z-index: 5; }

/* Product Grid */
.products-container {
  flex: 1;
  overflow-y: auto;
  padding: 6px;
  display: grid;
  grid-template-columns: repeat(6, 1fr);
  gap: 6px;
}

.product-card {
  border: 1px solid #ddd;
  border-radius: 4px;
  background: #fff;
  cursor: pointer;
  transition: 0.2s;
  font-size: 12px;
  padding: 3px;
}

.product-card:hover { background: #f1f1f1; }

.product-card img {
  width: 100%;
  height: 65px;
  object-fit: cover;
  border-radius: 4px;
  margin-bottom: 2px;
}

.product-card h4 {
  font-size: 12px;
  margin: 0;
  line-height: 1.2;
}

.product-card p {
  font-size: 12px;
  margin: 2px 0 0 0;
  font-weight: bold;
  color: #333;
}

/* RIGHT: Cart */
.cart { flex: 1; display: flex; flex-direction: column; background: #fafafa; border-left: 1px solid #ddd; height: 100vh; position: sticky; top: 0; padding: 10px; }
.cart h3 { margin: 0 0 10px; }

.cart-items-container { flex: 1; overflow-y: auto; margin-bottom: 10px; }

.cart-items-container table { width: 100%; border-collapse: collapse; font-size: 13px; }
.cart-items-container th, .cart-items-container td { border: 1px solid #ccc; padding: 5px; text-align: center; }

.cart-footer { margin-top: auto; padding-top: 6px; border-top: 1px solid #ddd; background: #fff; }

button { padding: 8px 14px; border: none; border-radius: 6px; cursor: pointer; }

#goDeliveryCheckoutBtn {
  background: #28a745;
  color: white;
  width: 100%;
  font-size: 14px;
}

#goDeliveryCheckoutBtn:hover { background: #218838; }

/* Responsive */
@media (max-width: 1100px) { .products-container { grid-template-columns: repeat(5, 1fr); } }
@media (max-width: 900px) {
    .order-page { flex-direction: column; }
    .products-section { flex: none; height: 50vh; }
    .cart { position: relative; flex: none; height: 50vh; }
    .products-container { grid-template-columns: repeat(4, 1fr); }
}
@media (max-width: 600px) { .products-container { grid-template-columns: repeat(3, 1fr); } }
</style>
</head>

<body>

<div class="order-page">

    <!-- LEFT: Products -->
    <div class="products-section">
        <div class="products-header">
            <h2>Delivery Order <?= $editOrder ? "(Editing #".$editOrder['order_id'].")" : "" ?></h2>
        </div>

        <div class="products-container">
            <?php
            $res = $conn->query("SELECT id, name, price, image FROM products");
            while($row = $res->fetch_assoc()){
                $img = $row['image'] ? $row['image'] : 'no_image.png';
                echo "
                <div class='product-card' data-id='{$row['id']}' data-name='{$row['name']}' data-price='{$row['price']}'>
                    <img src='uploads/{$img}' alt='{$row['name']}'>
                    <h4>{$row['name']}</h4>
                    <p>৳".number_format($row['price'],2)."</p>
                </div>
                ";
            }
            ?>
        </div>
    </div>

    <!-- RIGHT: Cart -->
    <div class="cart">
        <h3>🛒 Delivery Cart</h3>
        <div class="cart-items-container">
            <table id="deliveryCartTable">
                <thead>
                    <tr><th>Item</th><th>Qty</th><th>Price</th><th>Total</th><th>❌</th></tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>

        <div class="cart-footer">
            <h3>Total: ৳<span id="deliveryGrandTotal">0.00</span></h3>
            <button id="goDeliveryCheckoutBtn">
                <?= $editOrder ? "Update Delivery Order" : "Submit Delivery Order" ?>
            </button>
        </div>
    </div>

</div>

<!-- Delivery Page JS -->
<script src="order_delivery.js"></script>

<script>
// Check out → save cart & go to delivery checkout page
document.getElementById("goDeliveryCheckoutBtn").onclick = function () {

    // Save to localStorage
    localStorage.setItem("deliveryCart", JSON.stringify(window.deliveryCart));

    // Send via GET to checkout page
    const cartData = encodeURIComponent(JSON.stringify(window.deliveryCart));

    window.location.href = "delivery_checkout.php?cart=" + cartData;
};

</script>
<script>
// Initialize delivery cart if not already
window.deliveryCart = window.deliveryCart || [];

// Update delivery cart table
function updateDeliveryCartTable() {
    const tbody = document.querySelector("#deliveryCartTable tbody");
    tbody.innerHTML = "";
    let grandTotal = 0;

    window.deliveryCart.forEach((item, idx) => {
        const total = item.price * item.qty;
        grandTotal += total;
        tbody.innerHTML += `
            <tr>
                <td>${item.name}</td>
                <td><input type="number" min="1" value="${item.qty}" data-idx="${idx}" class="qty-input" style="width:50px;"></td>
                <td>${item.price.toFixed(2)}</td>
                <td>${total.toFixed(2)}</td>
                <td><button class="remove-btn" data-idx="${idx}">❌</button></td>
            </tr>
        `;
    });

    document.getElementById("deliveryGrandTotal").innerText = grandTotal.toFixed(2);

    // Add event listeners for qty changes
    document.querySelectorAll(".qty-input").forEach(input => {
        input.onchange = function () {
            const i = parseInt(this.dataset.idx);
            const val = parseInt(this.value);
            if (val < 1) this.value = 1;
            window.deliveryCart[i].qty = parseInt(this.value);
            updateDeliveryCartTable();
        };
    });

    // Add event listeners for remove buttons
    document.querySelectorAll(".remove-btn").forEach(btn => {
        btn.onclick = function () {
            const i = parseInt(this.dataset.idx);
            window.deliveryCart.splice(i, 1);
            updateDeliveryCartTable();
        };
    });
}

// Handle product click
document.querySelectorAll(".product-card").forEach(card => {
    card.onclick = function () {
        const id = parseInt(this.dataset.id);
        const name = this.dataset.name;
        const price = parseFloat(this.dataset.price);

        const existing = window.deliveryCart.find(it => it.id === id);
        if (existing) existing.qty += 1;
        else window.deliveryCart.push({ id, name, price, qty: 1 });

        updateDeliveryCartTable();
    };
});

// Initialize table if editing existing order
updateDeliveryCartTable();
</script>

</body>
</html>
