<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include "db.php";
session_start();
header('Content-Type: application/json');

// Set timezone to Bangladesh
date_default_timezone_set("Asia/Dhaka");

// --- Check Order ID ---
if (!isset($_GET['order_id'])) {
  echo json_encode(["status" => "error", "message" => "No order ID provided."]);
  exit;
}

$order_id = intval($_GET['order_id']);

// Fetch order
$order_res = $conn->query("SELECT * FROM orders WHERE id = $order_id");
if (!$order_res || $order_res->num_rows === 0) {
  echo json_encode(["status" => "error", "message" => "Order not found."]);
  exit;
}
$order = $order_res->fetch_assoc();

// Fetch order items
$items_res = $conn->query("SELECT * FROM order_items WHERE order_id = $order_id");
$items = [];
if ($items_res) {
  while ($row = $items_res->fetch_assoc()) {
    $items[] = $row;
  }
}

// Store cancellation log
$cancelData = [
  "order" => $order,
  "items" => $items
];
$cancelJson = $conn->real_escape_string(json_encode($cancelData));

$conn->query("
  INSERT INTO order_cancellations (order_id, order_data, cancelled_by)
  VALUES ($order_id, '$cancelJson', '{$_SESSION['username']}')
");

/* --------------------------------------------------------------
   ✅ RETURN STOCK FOR SOLID PRODUCTS (MATCH BY NAME)
--------------------------------------------------------------- */

foreach ($items as $itm) {

    $pname = $itm['product_name'];
    $qty   = intval($itm['qty']);

    if ($qty <= 0) continue;

    // Check if the product is a solid product
    $chk = $conn->prepare("
        SELECT id 
        FROM pu_product 
        WHERE p_product_name = ?
          AND product_type = 'Solid Product'
        LIMIT 1
    ");
    $chk->bind_param("s", $pname);
    $chk->execute();
    $res = $chk->get_result();

    if ($res && $res->num_rows > 0) {

        // Check solid_stock row
        $stockCheck = $conn->prepare("
            SELECT id, qty 
            FROM solid_stock 
            WHERE product_name = ?
            LIMIT 1
        ");
        $stockCheck->bind_param("s", $pname);
        $stockCheck->execute();
        $stockRes = $stockCheck->get_result();

        if ($stockRes && $stockRes->num_rows > 0) {

            // Update existing stock qty
            $st = $stockRes->fetch_assoc();
            $newQty = $st['qty'] + $qty;

            $up = $conn->prepare("
                UPDATE solid_stock 
                SET qty = ?, updated_at = NOW() 
                WHERE id = ?
            ");
            $up->bind_param("ii", $newQty, $st['id']);
            $up->execute();
            $up->close();

        } else {

            // Insert new stock row
            $qtyType = "pcs";
            $ins = $conn->prepare("
                INSERT INTO solid_stock (product_name, qty, qty_type, updated_at)
                VALUES (?, ?, ?, NOW())
            ");
            $ins->bind_param("sis", $pname, $qty, $qtyType);
            $ins->execute();
            $ins->close();
        }

        $stockCheck->close();
    }

    $chk->close();
}

/* --------------------------------------------------------------
   CASH / BALANCE UPDATE
--------------------------------------------------------------- */

$type = 'order_cancel';
$category = $order['order_type'];
$reference_id = $order_id;
$description = "Order #{$order_id} cancelled by {$_SESSION['username']}";
$amount = floatval($order['final_total']);
$direction = 'out';

$created_at = date("Y-m-d H:i:s");

// Previous cash balance
$balanceRes = $conn->query("SELECT current_balance FROM cash_balance WHERE id = 1");
$prev_balance = ($balanceRes && $balanceRes->num_rows > 0)
                ? floatval($balanceRes->fetch_assoc()['current_balance'])
                : 0.00;

$current_balance = $prev_balance;

// Update only if payment was cash
if (strtolower($order['payment_type']) === 'cash') {
    $current_balance = max(0, $prev_balance - $amount);
    $conn->query("UPDATE cash_balance SET current_balance = $current_balance, updated_at = NOW()");
}

// Log the transaction
$stmt = $conn->prepare("
  INSERT INTO transactions 
  (type, category, reference_id, description, amount, previous_balance, current_balance, direction, created_at)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");
$stmt->bind_param("ssisdddss",
  $type, $category, $reference_id, $description,
  $amount, $prev_balance, $current_balance,
  $direction, $created_at
);
$stmt->execute();
$stmt->close();

// Delete order items
if (!$conn->query("DELETE FROM order_items WHERE order_id = $order_id")) {
  echo json_encode(["status" => "error", "message" => "Failed to delete order items."]);
  exit;
}

// Delete order
if (!$conn->query("DELETE FROM orders WHERE id = $order_id")) {
  echo json_encode(["status" => "error", "message" => "Failed to delete order."]);
  exit;
}

echo json_encode([
  "status" => "success",
  "message" => "Order deleted, balance updated, solid stock restored successfully."
]);

?>
