<?php 
session_start(); 
if(!isset($_SESSION['username'])){
    header("Location: login.html"); 
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>POS Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="dashboard.css">
<style>
/* ===== Basic Layout ===== */
body {
  margin: 0;
  font-family: Arial, sans-serif;
  background: #f9f9f9;
  display: flex;
  flex-direction: column;
  min-height: 100vh;
}

/* ===== Header ===== */
.header {
  display: flex;
  align-items: center;
  background: #2c3e50;
  color: white;
  padding: 12px 20px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

.hamburger {
  font-size: 24px;
  cursor: pointer;
  margin-right: 15px;
  user-select: none;
}

.header h2 {
  margin: 0;
  font-size: 20px;
  cursor: pointer;
}

/* ===== Sidebar Popup ===== */
.sidebar {
  position: fixed;
  top: 0;
  left: -250px;
  width: 250px;
  height: 100%;
  background: #2c3e50;
  color: #ecf0f1;
  display: flex;
  flex-direction: column;
  padding-top: 20px;
  box-shadow: 3px 0 8px rgba(0,0,0,0.2);
  transition: left 0.3s ease;
  z-index: 1000;
}
.sidebar.active { left: 0; }

.sidebar a {
  padding: 15px 20px;
  text-decoration: none;
  color: #ecf0f1;
  font-size: 16px;
  border-left: 4px solid transparent;
  transition: background 0.3s, border-left 0.3s;
  cursor: pointer;
}
.sidebar a:hover {
  background: #34495e;
  border-left: 4px solid #1abc9c;
}

/* Overlay for popup */
.overlay {
  display: none;
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.4);
  z-index: 900;
}
.overlay.active { display: block; }

/* ===== Main Content ===== */
.main-content {
  flex: 1;
  padding: 10px 15px; /* reduced padding */
  overflow-y: auto;
}

/* ===== Dashboard Buttons ===== */
.dashboard-buttons {
  display: grid;
  grid-template-columns: repeat(auto-fit,minmax(180px,1fr));
  gap: 20px;
  margin-top: 30px;
}
.dashboard-btn {
  background:#ffffff;
  border-radius:12px;
  padding:25px 10px;
  text-align:center;
  font-size:18px;
  font-weight:600;
  color:#2c3e50;
  box-shadow:0 3px 8px rgba(0,0,0,0.1);
  transition:all 0.3s;
  cursor:pointer;
}
.dashboard-btn:hover {
  background:#1abc9c;
  color:#fff;
  transform:scale(1.05);
}

/* ===== Modal Styles (New Order) ===== */
.modal {
  display:none;
  position:fixed;
  z-index:2000;
  left:0;top:0;width:100%;height:100%;
  background:rgba(0,0,0,0.5);
  justify-content:center;align-items:center;
}
.modal-content {
  background:#fff;padding:30px;border-radius:12px;width:90%;max-width:400px;text-align:center;
}
.option {
  background:#007bff;color:white;padding:12px;margin:10px 0;border-radius:8px;cursor:pointer;font-size:16px;transition:0.2s;
}
.option:hover {background:#0056b3;transform:scale(1.05);}
.close {float:right;font-size:20px;cursor:pointer;color:#333;}
</style>
</head>


<body>

<!-- ===== Header with Hamburger ===== -->
<div class="header">
  <div class="hamburger" onclick="toggleSidebar()">☰</div>
  <h2 onclick="loadHomePage()">POS Menu</h2>
</div>

<!-- ===== Sidebar ===== -->
<div class="sidebar" id="sidebar">
  <a href="#" id="newOrderBtn">+ New Order</a>
  <a onclick="loadPage('order_list_New.php')">📑 Order List</a>
  <a onclick="loadPage('rest_items.php')">♻️ Rest Items</a>
    <a onclick="loadPage('remaining_items.php')">📋 Remining Order List</a>
  <a onclick="loadPage('product_add.php')">📦 Product</a>
  <a onclick="loadPage('category_add.php')">📂 Category</a>
  <a onclick="loadPage('supplier.php')">🏢 Supplier</a>
  <a onclick="loadPage('purchase.php')">🛒 Purchase</a>
  <a onclick="loadPage('purchase_product_new.php')">📜 Purchase Products</a>
  <a onclick="loadPage('purchase_history.php')">📜 Purchase History</a>
  <a onclick="loadPage('expense.php')">💰 Expense</a>
  <a onclick="loadPage('fixed_expense.php')">🏠 Fixed Expense</a> 
  <a href="https://phizixclub.com/reasturant-pos/stock_management.php">📦 Stock Management</a>
  <a onclick="loadPage('staff.php')">👨‍🍳 Staff</a>
  <a onclick="loadPage('staff_payment.php')">💳 Payment</a>
  <a onclick="loadPage('reports.php')">📊 Reports</a>
  <a onclick="loadPage('cb_balance.php')">💰 C/B Balances</a>
    <a onclick="loadPage('order_pad.php')">📝 Order Pad</a>
  <a onclick="loadPage('admin_dashboard.php')">🧑‍💼 Admin Dash</a>
  <a href="logout.php">🚪 Logout</a>
</div>

<!-- Overlay -->
<div class="overlay" id="overlay" onclick="toggleSidebar()"></div>

<!-- ===== Main Content ===== -->
<div class="main-content" id="mainContent">
  <h1>Welcome, <?php echo $_SESSION['username']; ?>!</h1>
  <p>Select an option to get started.</p>
  <div class="dashboard-buttons">
    <div class="dashboard-btn" onclick="openNewOrderModal()">🍽️ New Order</div>
    <div class="dashboard-btn" onclick="loadPage('order_list_New.php')">📑 Order List</div>
    <div class="dashboard-btn" onclick="loadPage('rest_items.php')">♻️ Rest Items</div>
        <div class="dashboard-btn" onclick="loadPage('remaining_items.php')">📋 Remining Order List</div>
    <div class="dashboard-btn" onclick="loadPage('product_add.php')">📦 Product</div>
    <div class="dashboard-btn" onclick="loadPage('category_add.php')">📂 Category</div>
    <div class="dashboard-btn" onclick="loadPage('supplier.php')">🏢 Supplier</div>
    <div class="dashboard-btn" onclick="loadPage('purchase.php')">🛒 Purchase</div>
    <div class="dashboard-btn" onclick="loadPage('purchase_product_new.php')">📜 Purchase Products</div>
    <div class="dashboard-btn" onclick="loadPage('purchase_history.php')">📜 Purchase History</div>
    <div class="dashboard-btn" onclick="loadPage('expense.php')">💰 Expense</div>
    <div class="dashboard-btn" onclick="loadPage('fixed_expense.php')">🏠 Fixed Expense </div>
    <div class="dashboard-btn" onclick="window.location.href='https://phizixclub.com/reasturant-pos/stock_management.php'">📦 Stock Management</div>
    <div class="dashboard-btn" onclick="loadPage('staff.php')">👨‍🍳 Staff</div>
    <div class="dashboard-btn" onclick="loadPage('payment.php')">💳 Payment</div>
    <div class="dashboard-btn" onclick="loadPage('reports.php')">📊 Reports</div>
    <div class="dashboard-btn" onclick="loadPage('cb_balance.php')">💰 C/B Balances</div>
<div class="dashboard-btn" onclick="loadPage('order_pad.php')">📝 Order Pad</div>
    <div class="dashboard-btn" onclick="loadPage('admin_dashboard.php')">🧑‍💼 Admin Dash</div>
    <div class="dashboard-btn" onclick="window.location='logout.php'">🚪 Logout</div>
  </div>
</div>


<!-- ===== Modal (New Order) ===== -->
<div class="modal" id="orderModal">
  <div class="modal-content">
    <span class="close" id="closeModal">&times;</span>
    <h2>Select Order Type</h2>
    <div class="option" onclick="selectOrder('dinein')">🍽️ Dine-In</div>
    <div class="option" onclick="selectOrder('collection')">📦 Collection</div>
    <div class="option" onclick="selectOrder('delivery')">🚚 Delivery</div>
  </div>
</div>

<!-- ===== Scripts ===== -->
<script>
// Sidebar toggle
function toggleSidebar() {
  const sidebar = document.getElementById("sidebar");
  const overlay = document.getElementById("overlay");
  sidebar.classList.toggle("active");
  overlay.classList.toggle("active");
}

// Page loader (keeps JS functionality like order/cart working)
function loadPage(page){
  fetch(page)
  .then(res => res.text())
  .then(data => {
    const content = document.getElementById("mainContent");
    content.innerHTML = data;

    // Reinitialize JS from loaded page
    const scripts = content.querySelectorAll("script");
    scripts.forEach(oldScript => {
      const newScript = document.createElement("script");
      if (oldScript.src) {
        newScript.src = oldScript.src;
        newScript.onload = () => {
          if (typeof initCollectionPage === "function") initCollectionPage();
          if (typeof initDineinPage === "function") initDineinPage();
        };
      } else {
        newScript.textContent = oldScript.textContent;
      }
      document.body.appendChild(newScript);
      oldScript.remove();
    });
  });
}

// Modal handling
const orderModal = document.getElementById("orderModal");
document.getElementById("newOrderBtn").onclick = e => { 
  e.preventDefault(); 
  orderModal.style.display = "flex"; 
  toggleSidebar(); 
}
document.getElementById("closeModal").onclick = () => orderModal.style.display = "none";
window.onclick = e => { if(e.target == orderModal) orderModal.style.display = "none"; }

function selectOrder(type){
  orderModal.style.display = "none";
  if(type === 'dinein'){ loadPage('dinein.php'); }
  else if(type === 'collection'){ loadPage('collection.php'); }
  else if(type === 'delivery'){ loadPage('delivery.php'); }
}


function showDeliveryMessage() {
  alert("🚧 Delivery is under development. Please check back later.");
}

function loadHomePage() {
  const content = document.getElementById("mainContent");
  content.innerHTML = `
    <h1>Welcome, <?php echo $_SESSION['username']; ?>!</h1>
    <p>Select an option to get started.</p>
    <div class="dashboard-buttons">
      <div class="dashboard-btn" onclick="openNewOrderModal()">🍽️ New Order</div>
      <div class="dashboard-btn" onclick="loadPage('order_list_New.php')">📑 Order List</div>
      <div class="dashboard-btn" onclick="loadPage('rest_items.php')">♻️ Rest Items</div>
            <div class="dashboard-btn" onclick="loadPage('remaining_items.php')">📋 Remining Order List</div>
      <div class="dashboard-btn" onclick="loadPage('product_add.php')">📦 Product</div>
      <div class="dashboard-btn" onclick="loadPage('category_add.php')">📂 Category</div>
      <div class="dashboard-btn" onclick="loadPage('supplier.php')">🏢 Supplier</div>
      <div class="dashboard-btn" onclick="loadPage('purchase.php')">🛒 Purchase</div>
      <div class="dashboard-btn" onclick="loadPage('purchase_product_new.php')">📜 Purchase Products</div>
      <div class="dashboard-btn" onclick="loadPage('purchase_history.php')">📜 Purchase History</div>
      <div class="dashboard-btn" onclick="loadPage('expense.php')">💰 Expense</div>
      <div class="dashboard-btn" onclick="loadPage('fixed_expense.php')">🏠 Fixed Expense </div>
    <div class="dashboard-btn" onclick="window.location.href='https://phizixclub.com/reasturant-pos/stock_management.php'">📦 Stock Management</div>
      <div class="dashboard-btn" onclick="loadPage('staff.php')">👨‍🍳 Staff</div>
      <div class="dashboard-btn" onclick="loadPage('payment.php')">💳 Payment</div>
      <div class="dashboard-btn" onclick="loadPage('reports.php')">📊 Reports</div>
      <div class="dashboard-btn" onclick="loadPage('cb_balance.php')">💰 C/B Balances</div>
      <div class="dashboard-btn" onclick="loadPage('order_pad.php')">📝 Order Pad</div>
      <div class="dashboard-btn" onclick="loadPage('admin_dashboard.php')">🧑‍💼 Admin Dash</div>
      <div class="dashboard-btn" onclick="window.location='logout.php'">🚪 Logout</div>
    </div>
  `;
}
function openNewOrderModal() {
  document.getElementById("orderModal").style.display = "flex";
}
</script>

<script src="Dashboard.js"></script>
<script src="order.js"></script>
<script>
let wakeLock = null;

// Function to request screen wake lock
async function keepScreenAwake() {
  try {
    if ('wakeLock' in navigator) {
      wakeLock = await navigator.wakeLock.request('screen');
      console.log("✅ Screen will stay awake.");
    } else {
      console.warn("⚠️ Wake Lock API not supported on this browser.");
    }
  } catch (err) {
    console.error(`${err.name}, ${err.message}`);
  }
}

// Re-activate wake lock when tab becomes active again
document.addEventListener('visibilitychange', () => {
  if (wakeLock !== null && document.visibilityState === 'visible') {
    keepScreenAwake();
  }
});

// Request wake lock when page loads
keepScreenAwake();
</script>

</body>
</html>
