<?php
include "db.php";
header("Content-Type: application/json");
date_default_timezone_set("Asia/Dhaka");

$date = $_GET['date'] ?? date("Y-m-d");

// Get all transactions for this date
$q = $conn->prepare("SELECT * FROM transactions WHERE DATE(created_at) = ?");
$q->bind_param("s", $date);
$q->execute();
$res = $q->get_result();

$records = [];
$summary = [
  "sales" => 0,
  "purchase" => 0,
  "staff" => 0,
  "expense" => 0,
  "fixed_expense" => 0,
  "loss" => 0,
  "payment" => 0,
  "remaining" => 0
];

while ($r = $res->fetch_assoc()) {
  $records[] = $r;
  switch ($r['category']) {
    case 'order':
    case 'collection_order':
      $summary['sales'] += $r['amount'];
      break;
    case 'purchase':
      $summary['purchase'] += $r['amount'];
      break;
    case 'staff_cost':
      $summary['staff'] += $r['amount'];
      break;
    case 'expense':
      $summary['expense'] += $r['amount'];
      break;
    case 'fixed_expense':
      $summary['fixed_expense'] += $r['amount'];
      break;
    case 'item_loss':
      $summary['loss'] += $r['amount'];
      break;
    case 'payment':
      $summary['payment'] += $r['amount'];
      break;
  }
}

// Remaining = total sales - (all expenses + purchases)
$summary['remaining'] = $summary['sales']
  - ($summary['purchase'] + $summary['staff'] + $summary['expense'] + $summary['fixed_expense'] + $summary['loss'] + $summary['payment']);

echo json_encode(["summary" => $summary, "records" => $records]);
?>
