<?php
include "db.php";
date_default_timezone_set("Asia/Dhaka");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Daily Reports</title>
<style>
body {
  font-family: Arial, sans-serif;
  background: #f9fafb;
  margin: 0; padding: 0;
}
.container {
  max-width: 1100px;
  margin: 20px auto;
  background: #fff;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 6px rgba(0,0,0,0.1);
}
.header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 15px;
}
.header h2 { margin: 0; color: #333; }
.header input[type="date"] {
  padding: 8px;
  border-radius: 6px;
  border: 1px solid #ccc;
}
.header button {
  background: #007bff;
  color: white;
  border: none;
  padding: 8px 14px;
  border-radius: 6px;
  cursor: pointer;
}
.header button:hover { background: #0056b3; }

.summary {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
  gap: 15px;
  margin-bottom: 20px;
}
.card {
  background: #f1f5f9;
  border-radius: 10px;
  padding: 15px;
  text-align: center;
}
.card h3 {
  margin: 0;
  color: #333;
  font-size: 16px;
}
.card p {
  margin: 8px 0 0;
  font-size: 18px;
  font-weight: bold;
  color: #007bff;
}

table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 15px;
}
th, td {
  border: 1px solid #ddd;
  padding: 8px;
  text-align: center;
  font-size: 14px;
}
th {
  background: #007bff;
  color: white;
}
tbody tr:nth-child(even) { background: #f8f9fa; }
</style>
</head>
<body>

<div class="container">
  <div class="header">
    <h2>📅 Daily Reports</h2>
    <div>
      <input type="date" id="reportDate" value="<?php echo date('Y-m-d'); ?>">
      <button onclick="loadReport()">Find</button>
    </div>
  </div>

  <!-- Summary Cards -->
  <div class="summary" id="summary">
    <div class="card"><h3>Total Sales</h3><p id="totalSales">0.00</p></div>
    <div class="card"><h3>Total Purchase</h3><p id="totalPurchase">0.00</p></div>
    <div class="card"><h3>Staff Cost</h3><p id="totalStaff">0.00</p></div>
    <div class="card"><h3>Expense</h3><p id="totalExpense">0.00</p></div>
    <div class="card"><h3>Fixed Expense</h3><p id="totalFixed">0.00</p></div>
    <div class="card"><h3>Item Loss</h3><p id="totalLoss">0.00</p></div>
    <div class="card"><h3>Payment</h3><p id="totalPayment">0.00</p></div>
    <div class="card"><h3>Remaining</h3><p id="totalRemaining">0.00</p></div>
  </div>

  <!-- Table -->
  <table id="reportTable">
    <thead>
      <tr>
        <th>ID</th>
        <th>Type</th>
        <th>Category</th>
        <th>Reference ID</th>
        <th>Description</th>
        <th>Amount</th>
        <th>Prev Balance</th>
        <th>Curr Balance</th>
        <th>Direction</th>
        <th>Date</th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>
</div>

<script>
async function loadReport() {
  const date = document.getElementById('reportDate').value;
  if (!date) {
    alert("Please select a date!");
    return;
  }

  const res = await fetch("daily_reports_action.php?date=" + date);
  const data = await res.json();

  // Update summary
  document.getElementById("totalSales").innerText = data.summary.sales.toFixed(2);
  document.getElementById("totalPurchase").innerText = data.summary.purchase.toFixed(2);
  document.getElementById("totalStaff").innerText = data.summary.staff.toFixed(2);
  document.getElementById("totalExpense").innerText = data.summary.expense.toFixed(2);
  document.getElementById("totalFixed").innerText = data.summary.fixed_expense.toFixed(2);
  document.getElementById("totalLoss").innerText = data.summary.loss.toFixed(2);
  document.getElementById("totalPayment").innerText = data.summary.payment.toFixed(2);
  document.getElementById("totalRemaining").innerText = data.summary.remaining.toFixed(2);

  // Update table
  const tbody = document.querySelector("#reportTable tbody");
  tbody.innerHTML = "";
  data.records.forEach(row => {
    const tr = document.createElement("tr");
    tr.innerHTML = `
      <td>${row.id}</td>
      <td>${row.type}</td>
      <td>${row.category}</td>
      <td>${row.reference_id ?? ''}</td>
      <td>${row.description}</td>
      <td>${row.amount}</td>
      <td>${row.previous_balance}</td>
      <td>${row.current_balance}</td>
      <td>${row.direction}</td>
      <td>${row.created_at}</td>
    `;
    tbody.appendChild(tr);
  });
}

window.onload = loadReport;
</script>

</body>
</html>
