<?php
include "db.php";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("DB Connection failed");

$result = $conn->query("SELECT * FROM customers ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Customer List</title>
<style>
    body {
        font-family: "Poppins", sans-serif;
        background: #f5f7fb;
        margin: 0;
        padding: 20px;
    }

    h2 {
        text-align: center;
        color: #007bff;
        margin-bottom: 25px;
    }

    .table-container {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        overflow-x: auto;
        padding: 20px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        min-width: 700px;
    }

    th, td {
        padding: 12px 15px;
        border-bottom: 1px solid #eaeaea;
        text-align: left;
        font-size: 14px;
    }

    th {
        background: #007bff;
        color: #fff;
        font-weight: 600;
    }

    tr:hover {
        background: #f1f8ff;
    }

    @media(max-width: 768px) {
        body {
            padding: 10px;
        }
        table {
            min-width: unset;
            font-size: 13px;
        }
        th, td {
            padding: 10px 8px;
        }
    }

    .back-btn {
        display: inline-block;
        background: #007bff;
        color: #fff;
        text-decoration: none;
        padding: 10px 15px;
        border-radius: 8px;
        font-size: 14px;
        margin-bottom: 15px;
        transition: 0.3s;
    }
    .back-btn:hover {
        background: #0056b3;
    }
</style>
</head>
<body>

<!--<a href="admin_dashboard.php" class="back-btn">⬅ Back to Dashboard</a>-->

<h2>👥 Customer List</h2>

<div class="table-container">
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Mobile</th>
                <th>Address</th>
                <th>Created Date</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result && $result->num_rows > 0): ?>
                <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['mobile']) ?></td>
                        <td><?= htmlspecialchars($row['address']) ?></td>
                        <td><?= date("d M Y h:i A", strtotime($row['created_at'])) ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="5" style="text-align:center;">No customers found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

</body>
</html>
<?php $conn->close(); ?>
